/*
 *  linux/arch/mips/toshiba-boards/tsdb/prom.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 *
 * $Id: prom.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/string.h>
#include <asm/mipsregs.h>
#include <asm/cpu.h>
#include <asm/toshiba-boards/pmon.h>
#include <asm/toshiba-boards/tsdb.h>

#ifdef CONFIG_CPU_TX49XX
extern int mips_configk0;
#endif
extern int mips_config_cwfon;

int __init tsdb_prom_init(int argc, char *argv[])
{
	if (argc == -1)
		return 0;
#if defined(CONFIG_CPU_TX49XX)
	/* TSDB-BUG: Kernel space must be uncached. (V320USC R4300 mode bug) */
	if ((mips_cpu.processor_id & 0xff00) == PRID_IMP_R4300)
		mips_configk0 = CONF_CM_UNCACHED;
#endif
#if 1	/* XXX ? */
	mips_config_cwfon = 0;
#endif

	return 0;
}
