/*
 * linux/arch/mips/toshiba-boards/tsdb/setup.c
 * $Id: setup.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * Setup pointers to hardware-dependent routines.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/ioport.h>
#include <linux/kdev_t.h>
#include <linux/parport.h>
#include <linux/pci.h>
#include <asm/system.h>
#include <asm/param.h>
#include <asm/reboot.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/toshiba-boards/pmon.h>
#include <asm/toshiba-boards/pci.h>
#include <asm/toshiba-boards/tsdb.h>
#include <asm/mc146818rtc.h>	/* bad name... */
#include <asm/ns87338.h>
#include <asm/bootinfo.h>
#include <asm/cpu.h>
#include <asm/pci.h>
#include <asm/time.h>
#if defined(CONFIG_SERIAL)
#include <linux/serial.h>
#include <asm/serial.h>
#endif

extern struct rtc_ops tsdb_rtc_ops;
extern struct pci_ops tsdb_pci_ops;
extern int tsdb_pci_map_irq(struct pci_dev *dev, u8 slot, u8 pin);
extern void tsdb_irq_setup(void) __init;
extern void tsdb_time_init(void) __init;
extern void tsdb_timer_setup(struct irqaction *irq) __init;
extern int mips_parport_base;
extern int mips_parport_irq;

#ifdef CONFIG_REMOTE_DEBUG
extern int __init early_serial_kgdb_setup(struct serial_struct *req);
extern void breakpoint(void);
#define TOMON(s) printk(s); breakpoint()
#else
#define TOMON(s) pmon_printf(s); pmon_halt()
#endif
extern void wait_for_keypress(void);

static void tsdb_machine_restart(char *command)
{
	cli();
	printk("Rebooting...");
	*tsdb_softreset_ptr = 0;
}

static void tsdb_machine_halt(void)
{
	cli();
	printk("Press any key to reboot.\n");
	wait_for_keypress();
	*tsdb_softreset_ptr = 0;
}

static void tsdb_machine_power_off(void)
{
	cli();
	printk("Press any key to reboot.\n");
	wait_for_keypress();
	*tsdb_softreset_ptr = 0;
}

/* utility routines for LED Display */
void tsdb_leddisp_puts(const char *s)
{
	int i;
	for (i = 0; i < 8; i++) {
		char c;
		if (*s)
			c = *s++;
		else
			c = ' ';
		tsdb_leddisp_putc(i, c);
	}
}
void tsdb_leddisp_put(unsigned long val)
{
	int i;
	for (i = 7; i >= 0; i--) {
		unsigned char v = val & 0x0f;
		char c = v < 10 ? (v + '0') : (v - 10 + 'A');
		tsdb_leddisp_putc(i, c);
		val >>= 4;
	}
}

#ifdef __BIG_ENDIAN
#undef DO_AUTOSWAP
#endif

static void __init tsdb_usc_setup(void)
{
	struct v320usc_reg * const usc_reg = (struct v320usc_reg *)TSDB_USC_BASE;
	int sdram_adbits = TSDB_SDRAM_APERTURE_ADBITS;

	/* set sdram_adbits as large as possible to cache BusWatch Timeout */
	while (((0xffffffff << (32 - sdram_adbits)) &
		(PHYSADDR(toshibaboards_memory_upper) - 1))
	       == 0)
		sdram_adbits++;
	/* MINIMUM 64M */
	if (sdram_adbits > 6)
		sdram_adbits = 6;

	usc_reg->int_cfg[0] = 0;
	usc_reg->int_cfg[1] = 0;
	usc_reg->int_cfg[2] = 0;
	usc_reg->int_cfg3 = 0;

	/* Setup REG Aperture */
	if (usc_reg->lb_reg_base !=
	    USC_LB_REG_BASE_BASE(TSDB_LB_USCREG_APERTURE)) {
		printk("PCI setup: LB_REG_BASE mismatch.\n");
		return;
	}
	usc_reg->pci_reg_base = TSDB_PCI_USCREG_APERTURE; /* disabled */
	/* Setup RAM Aperture */
	if ((usc_reg->lb_dram_base & USC_LB_DRAM_BASE_BASE_MASK) !=
	    USC_LB_DRAM_BASE_BASE(TSDB_LB_SDRAM_APERTURE)) {
		printk("PCI setup: LB_SDRAM_BASE mismatch.\n");
		return;
	}
	usc_reg->lb_dram_base = USC_LB_DRAM_BASE_BASE(TSDB_LB_SDRAM_APERTURE) |
		USC_LB_DRAM_BASE_SIZE(sdram_adbits) |
		USC_LB_DRAM_BASE_ENABLE;
	usc_reg->pci_mem_base = TSDB_PCI_SDRAM_APERTURE |
		PCI_BASE_ADDRESS_SPACE_MEMORY | PCI_BASE_ADDRESS_MEM_TYPE_32 |
		PCI_BASE_ADDRESS_MEM_PREFETCH;
	usc_reg->pci_mem_map = USC_PCI_MEM_MAP_MAP_ADR(TSDB_LB_SDRAM_APERTURE) |
		USC_PCI_MEM_MAP_SIZE(sdram_adbits) |
#ifdef __BIG_ENDIAN
		USC_PCI_MEM_MAP_SWAP(USC_SWAP8) |
#else
		USC_PCI_MEM_MAP_SWAP(USC_NOSWAP) |
#endif
		USC_PCI_MEM_MAP_REG_EN |
		USC_PCI_MEM_MAP_ENABLE;
	/* Setup PCI Aperture 0 (for I/O Space) */
	usc_reg->lb_pci_base[0] =
		USC_LB_PCI_BASE_BASE(TSDB_LB_PCI_APERTURE_0) |
		USC_LB_PCI_BASE_MAP_ADR(TSDB_PCI_PCI_APERTURE_0) |
		USC_LB_PCI_BASE_PCI_CMD_IO |
#ifdef __BIG_ENDIAN
#ifdef DO_AUTOSWAP
		USC_LB_PCI_BASE_SWAP(USC_AUTOSWAP) |
#else
		USC_LB_PCI_BASE_SWAP(USC_SWAP8) |
#endif
#else
		USC_LB_PCI_BASE_SWAP(USC_NOSWAP) |
#endif
		USC_LB_PCI_BASE_SIZE(TSDB_PCI_APERTURE_0_ADBITS) |
		USC_LB_PCI_BASE_ERR_EN;
	/* Setup PCI Aperture 1 (for Memory Space) */
	usc_reg->lb_pci_base[1] =
		USC_LB_PCI_BASE_BASE(TSDB_LB_PCI_APERTURE_1) |
		USC_LB_PCI_BASE_MAP_ADR(TSDB_PCI_PCI_APERTURE_1) |
#if 1
		/* Do not use MEMMUL, MEMINF: YMFPCI card causes M_ABORT. */
		USC_LB_PCI_BASE_PCI_CMD_MEM |
#else
		USC_LB_PCI_BASE_PCI_CMD_MEMINV |
#endif
#ifdef __BIG_ENDIAN
#ifdef DO_AUTOSWAP
		USC_LB_PCI_BASE_SWAP(USC_AUTOSWAP) |
#else
		USC_LB_PCI_BASE_SWAP(USC_SWAP8) |
#endif
#else
		USC_LB_PCI_BASE_SWAP(USC_NOSWAP) |
#endif
		USC_LB_PCI_BASE_SIZE(TSDB_PCI_APERTURE_1_ADBITS) |
		USC_LB_PCI_BASE_ERR_EN;
	/* Setup PCU Aperture */
	usc_reg->lb_pcu_base = USC_LB_PCU_BASE_BASE(TSDB_LB_PCU_APERTURE) |
		USC_LB_PCU_BASE_SIZE(TSDB_PCU_APERTURE_ADBITS) |
		USC_LB_PCU_BASE_ENABLE;
	usc_reg->pci_pcu_base = PCI_PCU_ADDRESS_SIZE_DISABLED;
	/* Setup ROM Aperture */
	usc_reg->lb_rom_base = USC_LB_ROM_BASE_BASE(TSDB_LB_ROM_APERTURE) |
		USC_LB_ROM_BASE_SIZE(TSDB_ROM_APERTURE_ADBITS) |
		USC_LB_ROM_BASE_WE;
	usc_reg->pci_rom_base = PCI_ROM_ADDRESS_SIZE_DISABLED;

	/* Enable Bus Watch Timeout and SDRAM Parity Error */
	usc_reg->lb_bus_cfg |= USC_LB_BUS_CFG_BW_TC_MASK;
	usc_reg->lb_bus_cfg |= USC_LB_BUS_CFG_ERR_EN | USC_LB_BUS_CFG_MERR_EN;

	usc_reg->pci_bus_cfg = USC_PCI_BUS_CFG_FAST_SCL |
#ifdef __BIG_ENDIAN
#ifdef DO_AUTOSWAP
		USC_PCI_BUS_CFG_PCU_SWAP(USC_AUTOSWAP) |
#else
		USC_PCI_BUS_CFG_PCU_SWAP(USC_SWAP8) |
#endif
#else
		USC_PCI_BUS_CFG_PCU_SWAP(USC_NOSWAP) |
#endif
#if 1 /* XXX PCI */
		USC_PCI_BUS_CFG_RBRST_MAX_256	/* burst support (256 words) */
#else
		USC_PCI_BUS_CFG_RBRST_MAX_4
#endif
		;

	usc_reg->pci_cmd |=
		PCI_COMMAND_MASTER | PCI_COMMAND_MEMORY;
#if 1 /* XXX PCI */
	usc_reg->pci_cmd |= PCI_COMMAND_INVALIDATE;
#endif
	usc_reg->pci_cmd |=
		PCI_COMMAND_PARITY | PCI_COMMAND_SERR;

	/* set USC heartbeat constant (XXX MasterClock 66MHz) */
	usc_reg->wd_hbi = (66*1000*1000 / 4096 / HZ) << USC_HB_TC_SHIFT;

	if (mips_cpu.cputype == CPU_TX39XX) {
		int mclk = 8250000;	/* perhaps MasterClock is 08MHz... */
		if ((mips_cpu.processor_id & 0xffff) == (PRID_IMP_TX39 | 0x0050)) {
			/* TX39H3 */
			switch (*tsdb_dipsw2_ptr & TSDB_DIPSW2_CLOCK_MASK) {
			case TSDB_DIPSW2_CLOCK_4:	/* 1:1 */
				mclk = 33000000;	/* 33MHz */
				break;
			case TSDB_DIPSW2_CLOCK_2_5:	/* 1:2 */
				mclk = 16500000;	/* 16.5MHz */
				break;
			case TSDB_DIPSW2_CLOCK_2:	/* 1:3 */
				mclk = 11000000;	/* 11MHz */
				break;
			case TSDB_DIPSW2_CLOCK_3:	/* 1:4 */
				mclk = 8250000;		/* 8.25MHz */
				break;
			}
		}
		usc_reg->wd_hbi = (mclk / 4096 / HZ) << USC_HB_TC_SHIFT;
	}
#if 0 /* XXX */
	switch (*tsdb_dipsw2_ptr & TSDB_DIPSW2_CLOCK_MASK) {
	case TSDB_DIPSW2_CLOCK_4:
	case TSDB_DIPSW2_CLOCK_3:
		/* XXX perhaps MasterClock is 33MHz... */
		usc_reg->wd_hbi = (33*1000*1000 / 4096 / HZ) << USC_HB_TC_SHIFT;
		break;
	}
#endif

#if 1
	/* Lock USC */
	usc_reg->system |= USC_SYSTEM_LOCK | USC_SYSTEM_CFG_LOCK;
#endif
}

#ifdef CONFIG_HAVE_BOARD_IO_FUNCS
#ifdef __LITTLE_ENDIAN
/* for Little Endian, we can use standard IO macros. */
#warning using CONFIG_HAVE_BOARD_IO_FUNCS in LittleEndian
#endif
static struct mips_io_funcs saved_io_funcs;
#define IS_PCU_PORT(port) \
	((PHYSADDR(mips_io_port_base + (port)) & ~(0xffffffff >> TSDB_PCU_APERTURE_ADBITS)) == TSDB_LB_PCU_APERTURE)
/* We may be able to use AUTP-SWAP features on USC... (but currently don't) */
/* Note: do not use read[bwl]/write[bwl] for PCU.. */
static void tsdb_outb(unsigned int value, unsigned long port) {
#ifdef __BIG_ENDIAN
	if (IS_PCU_PORT(port))
		port ^= 3;
#endif
	(*saved_io_funcs.outb)(value, port);
}
static void tsdb_outw(unsigned int value, unsigned long port) {
#ifdef __BIG_ENDIAN
	if (IS_PCU_PORT(port))
		port ^= 2;
#endif
	(*saved_io_funcs.outw)(value, port);
}
static unsigned char tsdb_inb(unsigned long port) {
#ifdef __BIG_ENDIAN
	if (IS_PCU_PORT(port))
		port ^= 3;
#endif
	return (*saved_io_funcs.inb)(port);
}
static unsigned short tsdb_inw(unsigned long port) {
#ifdef __BIG_ENDIAN
	if (IS_PCU_PORT(port))
		port ^= 2;
#endif
	return (*saved_io_funcs.inw)(port);
}
static void tsdb_outsb(unsigned long port, const void *addr, unsigned int count) {
#ifdef __BIG_ENDIAN
	if (IS_PCU_PORT(port))
		port ^= 3;
#endif
	(*saved_io_funcs.outsb)(port, addr, count);
}
static void tsdb_outsw(unsigned long port, const void *addr, unsigned int count) {
#ifdef __BIG_ENDIAN
	if (IS_PCU_PORT(port))
		port ^= 2;
#endif
	(*saved_io_funcs.outsw)(port, addr, count);
}
static void tsdb_insb(unsigned long port, void *addr, unsigned int count) {
#ifdef __BIG_ENDIAN
	if (IS_PCU_PORT(port))
		port ^= 3;
#endif
	(*saved_io_funcs.insb)(port, addr, count);
}
static void tsdb_insw(unsigned long port, void *addr, unsigned int count) {
#ifdef __BIG_ENDIAN
	if (IS_PCU_PORT(port))
		port ^= 3;
#endif
	(*saved_io_funcs.insw)(port, addr, count);
}
#endif /* CONFIG_HAVE_BOARD_IO_FUNCS */

void __init tsdb_setup(void)
{
	struct v320usc_reg *usc = (struct v320usc_reg *)TSDB_USC_BASE;
#if defined(CONFIG_SERIAL)
	int i;
	struct serial_struct req;
#endif
	unsigned long spio_config;

	toshibaboards_pci_io_resource.start = 0;
	toshibaboards_pci_io_resource.end = (1 << (32 - TSDB_PCI_APERTURE_0_ADBITS)) - 1;
	toshibaboards_pci_mem_resource.start = TSDB_LB_PCI_APERTURE_1;
	toshibaboards_pci_mem_resource.end = TSDB_LB_PCI_APERTURE_1 +
		(1 << (32 - TSDB_PCI_APERTURE_1_ADBITS)) - 1;

	tsdb_usc_setup();

	board_time_init = tsdb_time_init;
	board_timer_setup = tsdb_timer_setup;
	irq_setup = tsdb_irq_setup;
	/* map ioport 0 to PCI I/O space address 0 */
	set_io_port_base(KSEG1ADDR(TSDB_LB_PCI_APERTURE_0));

#ifdef CONFIG_HAVE_BOARD_IO_FUNCS
	saved_io_funcs = mips_io_funcs;
	mips_io_funcs.outb = tsdb_outb;
	mips_io_funcs.outw = tsdb_outw;
	mips_io_funcs.inb = tsdb_inb;
	mips_io_funcs.inw = tsdb_inw;
	mips_io_funcs.outsb = tsdb_outsb;
	mips_io_funcs.outsw = tsdb_outsw;
	mips_io_funcs.insb = tsdb_insb;
	mips_io_funcs.insw = tsdb_insw;
#endif /* CONFIG_HAVE_BOARD_IO_FUNCS */

	/* disable all OnBoard I/O interrupts */
	*tsdb_ioc_imask_ptr = 0;
	*tsdb_pci_imask_ptr = 0;

	_machine_restart = tsdb_machine_restart;
	_machine_halt = tsdb_machine_halt;
	_machine_power_off = tsdb_machine_power_off;

	rtc_ops = &tsdb_rtc_ops;

	if (*tsdb_dipsw2_ptr & TSDB_DIPSW2_BUSE) {
		toshibaboards_pci_ops = &tsdb_pci_ops;
		toshibaboards_pci_map_irq = tsdb_pci_map_irq;
	}

	/* Enable Parallel Port (XXX done by Monitor?) */
	spio_config = TSDB_SUPERIO_CONFIG - mips_io_port_base;
	ns87338_writeb(spio_config, FER,
		       ns87338_readb(spio_config, FER) | FER_LPT);
	ns87338_writeb(spio_config, FAR,
		       (ns87338_readb(spio_config, FAR) & ~FAR_LPT_MASK) | FAR_LPTB);

	*tsdb_led_ptr = 0xff;
	tsdb_leddisp_puts("SDB rev");
	tsdb_leddisp_putc(7, *tsdb_board_rev_ptr + '0');
	printk("TOSHIBA SDB (Rev %d) --- FPGA(Rev %d) USC(Dev %04x Rev %04x) SuperIO(ID %x) DIPSW:%02x,%02x\n",
	       *tsdb_board_rev_ptr, *tsdb_fpga_rev_ptr,
	       usc->pci_device, usc->pci_cc_rev.rev,
	       ns87338_readb(spio_config, SID),
	       *tsdb_dipsw1_ptr, *tsdb_dipsw2_ptr);

#if defined(CONFIG_SERIAL)
	/* loop until early_serial_setup() returns error. */
	for(i = 0; ; i++) {
		memset(&req, 0, sizeof(struct serial_struct));
		req.line = i;
		if (i < 2) {
			unsigned long base =
				(i == 0) ? TSDB_UART0_BASE : TSDB_UART1_BASE;
			req.baud_base = TSDB_BASE_BAUD;
			req.port = base - mips_io_port_base;
			req.irq = TSDB_IRQ_IOC_UART(i);
			req.flags = STD_COM_FLAGS;
			req.io_type = SERIAL_IO_PORT;
			req.type = PORT_16550A;
		}
		if (early_serial_setup(&req))
			break;
#ifdef CONFIG_REMOTE_DEBUG
		early_serial_kgdb_setup(&req);
#endif
	}
#endif

	if (ns87338_readb(spio_config, SID) != 0xff) {
		unsigned long tmp;
		mips_parport_base = TSDB_LPT_ADDR - mips_io_port_base;
		mips_parport_irq = TSDB_IRQ_IOC_PAR;
		/* TSDB-BUG: SDB always assert INT signal if we mask parport interrupt
		   by setting zero to bit4 of Control Register. */
		if (!(*tsdb_ioc_istat_ptr & TSDB_INTF_IOC_PAR))
			mips_parport_irq = PARPORT_IRQ_NONE;

		/* Enable ECP mode, set bit 2 of the CTR first */
		outb(0x04, mips_parport_base + 2);
		tmp = ns87338_readb(spio_config, PCR);
#if 0
		tmp |= PCR_EPP_ENABLE;
#endif
		tmp |= (PCR_EPP_IEEE | PCR_ECP_ENABLE | PCR_ECP_CLK_ENA);
		ns87338_writeb(spio_config, PCR, tmp);

		/* LPT CTR bit 5 controls direction of parallel port */
		tmp = ns87338_readb(spio_config, PTR);
		tmp |= PTR_LPT_REG_DIR;
		ns87338_writeb(spio_config, PTR, tmp);

		/* Configure IRQ to Push Pull, Level Low */
		tmp = ns87338_readb(spio_config, PCR);
		tmp &= ~(PCR_IRQ_ODRAIN);
		tmp |= PCR_IRQ_POLAR;
		ns87338_writeb(spio_config, PCR, tmp);

		/* Enable Zero Wait State for ECP */
		tmp = ns87338_readb(spio_config, FCR);
		tmp |= FCR_ZWS_ENA;
		ns87338_writeb(spio_config, FCR, tmp);
	}
}
