/*
 *  linux/arch/mips/toshiba-boards/tx4927evb/prom.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 *
 * $Id: prom.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/string.h>
#include <linux/kernel.h>
#include <asm/toshiba-boards/pmon.h>
#include <asm/toshiba-boards/tx4927evb.h>

extern int tx4927evb_ccfg_toeon;
extern int tx4927evb_pci66;
extern int tx4927evb_pcic_trdyto;

int __init tx4927evb_prom_init(int argc, char **argv, char **envp)
{
	if (argc == -1) {
		if (strcmp(*argv, "toeoff") == 0)
			tx4927evb_ccfg_toeon = 0;
		else if (strcmp(*argv, "pci66=off") == 0)
			tx4927evb_pci66 = -1;
		else if (strcmp(*argv, "pci66=on") == 0)
			tx4927evb_pci66 = 1;
		else if (strcmp(*argv, "pci66=auto") == 0)
			tx4927evb_pci66 = 0;
		else if (strncmp(*argv, "trdyto=", 7) == 0) {
			tx4927evb_pcic_trdyto =
				simple_strtoul(*argv + 7, NULL, 0);
		} else {
			return 0;
		}
		return 1;
	}

	return 0;
}
