/*
 *  linux/arch/mips/toshiba-boards/tx4927evb/rtc.c
 * $Id: rtc.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * RTC routines for Dallas chip.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#include <asm/mc146818rtc.h>	/* bad name... */
#include <asm/toshiba-boards/tx4927evb.h>

static unsigned char tx4927evb_rtc_read_data(unsigned long addr)
{
	return *(tx4927evb_bramrtc_ptr + addr);
}

static void tx4927evb_rtc_write_data(unsigned char data, unsigned long addr)
{
	*(tx4927evb_bramrtc_ptr + addr) = data;
}

static int tx4927evb_rtc_bcd_mode(void)
{
	return 1;
}

struct rtc_ops tx4927evb_rtc_ops = {
	&tx4927evb_rtc_read_data,
	&tx4927evb_rtc_write_data,
	&tx4927evb_rtc_bcd_mode
};
