/*
 *  linux/arch/mips/toshiba-boards/tx4927evb/time.c
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 *
 * $Id: time.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/param.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/interrupt.h>

#include <asm/bootinfo.h>
#include <asm/mipsregs.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/time.h>

#include <asm/toshiba-boards/tx4927evb.h>

/* We use onchip r4k counter or TMR timer as our system wide timer interrupt running at 100HZ. */
int tx4927evb_use_r4k_timer;
#define tx4927evb_tmrptr		tx4927_tmrptr(0)	/* TMR0 */

/* Tick Timer divider */
#define TX4927EVB_TIMER_CCD	0	/* 1/2 */
#define TX4927EVB_TIMER_CLK	(TX4927EVB_IMCLK / (2 << TX4927EVB_TIMER_CCD))

static void
tx4927evb_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	tx4927evb_tmrptr->tisr = 0;	/* ack interrupt */
	timer_interrupt(irq, dev_id, regs);
}

extern void rtc_ds1553_init(void);

void __init tx4927evb_time_init(void)
{
	unsigned int ct0;
	int i;

	rtc_ds1553_init();

	if (tx4927_ccfgptr->ccfg & TX4927_CCFG_TINTDIS) {
		printk("Tick timer: use TX4927 timer0 interrupt.\n");
		tx4927evb_use_r4k_timer = 0;
	} else {
		printk("Tick timer: use r4k counter interrupt.\n");
		tx4927evb_use_r4k_timer = 1;
	}

	printk("calculating counter_frequency... ");

	tx4927evb_tmrptr->cpra = TX4927EVB_TIMER_CLK / HZ;
	tx4927evb_tmrptr->itmr = TXx927_TMTITMR_TIIE | TXx927_TMTITMR_TZCE;
	tx4927evb_tmrptr->ccdr = TX4927EVB_TIMER_CCD;
	tx4927evb_tmrptr->tcr =
		TXx927_TMTCR_TCE | TXx927_TMTCR_CCDE | TXx927_TMTCR_TMODE_ITVL;

	/* clear interval timer Int. */
	tx4927evb_tmrptr->tisr = 0;
	/* waiting for a new tick. */
	while (!(tx4927evb_tmrptr->tisr & TXx927_TMTISR_TIIS))
		;
	ct0 = read_32bit_cp0_register(CP0_COUNT);
	for (i = 0; i < 16; i++) {
		/* clear interval timer Int. */
		tx4927evb_tmrptr->tisr = 0;
		/* waiting for a next tick. */
		while (!(tx4927evb_tmrptr->tisr & TXx927_TMTISR_TIIS))
			;
	}
	mips_counter_frequency =
		(read_32bit_cp0_register(CP0_COUNT) - ct0) / 16 * HZ;
}

extern int setup_irq(unsigned int irq, struct irqaction *irqaction);
void __init tx4927evb_timer_setup(struct irqaction *irq)
{
	if (tx4927evb_use_r4k_timer) {
		unsigned int count;

		/* we are using the cpu counter for timer interrupts */
		setup_irq(TX4927EVB_IRQ_LOCAL_TIMER, irq);

		/* to generate the first timer interrupt */
		count = read_32bit_cp0_register(CP0_COUNT);
		write_32bit_cp0_register(CP0_COMPARE, count + mips_counter_frequency / HZ);
	} else {
		/* wrap default timer interupt handler */
		irq->handler = tx4927evb_timer_interrupt;
#if 0	/* disabled by TINTDIS */
		/* disable counter interrupt(IM7) */
		set_cp0_status(STATUSF_IP7, 0);
#endif
		/* enable timer interrupt */
		setup_irq(TX4927EVB_IRQ_IRC_TMR(0), irq);
	}
	printk("%08x(%d)\n", mips_counter_frequency, mips_counter_frequency);
}
