
#include <linux/kernel.h>
#include <linux/timer.h>
#include <linux/netdevice.h>

#if defined(CONFIG_MCT_SG100)

#define ETHER_IN_LED(i)		*((volatile unsigned char *) 0xb4001400) = (0xff << i) & 0x0f;
#define ETHER_OUT_LED(i)	*((volatile unsigned char *) 0xb4001800) = (0xff << i) & 0x0f;

#elif defined(CONFIG_MCT_SG4100)

#include <asm/tx4925.h>
#define ETHER_IN_LED(i)		tx4925_pioptr->dout = (tx4925_pioptr->din & 0xf0ffffff) | (((((unsigned long) 0xff) << i) & 0x0f) << 24);
#define ETHER_OUT_LED(i)	tx4925_pioptr->dout = (tx4925_pioptr->din & 0x0fffffff) | (((((unsigned long) 0xff) << i) & 0x0f) << 28);

#endif

static struct timer_list	ethled_timer;
static struct net_device_stats	*wan_stats;
static unsigned long		pre_tx_bytes, pre_rx_bytes;
static unsigned long		throughput_led[] = { 
	10*1024/10, 50*1024/10, 100*1024/10, 500*1024/10 };

#if 0
static void get_ether_info(struct net_device *dev, struct ether_info *info)
{
	void	*ioaddr;
	struct net_device_stats *stats;
	u8	media_status;

	ioaddr = (void *) dev->base_addr;
	stats = &((struct rtl8139_private *) dev->priv)->stats;
	media_status = RTL_R8(MediaStatus);
	info->linkup = !(media_status & 0x04);
	info->speed = (media_status & 0x08) ? SPEED_10 : SPEED_100;
	info->full_duplex = (RTL_R16(BasicModeCtrl) & 0x100) ? 1 : 0;
	info->tx_bytes = stats->tx_bytes;
	info->tx_packets = stats->tx_packets;
	info->tx_errors = stats->tx_errors;
	info->rx_bytes = stats->rx_bytes;
	info->rx_packets = stats->rx_packets;
	info->rx_errors = stats->rx_errors;
}
#endif

static void ethled_callback(unsigned long dummy)
{
	int		i;
	unsigned long	diff_tx_bytes, diff_rx_bytes;

	diff_tx_bytes = wan_stats->tx_bytes - pre_tx_bytes;
	diff_rx_bytes = wan_stats->rx_bytes - pre_rx_bytes;
	pre_tx_bytes = wan_stats->tx_bytes;
	pre_rx_bytes = wan_stats->rx_bytes;

	for (i = 0; i < 4; i++) {
		if ( diff_tx_bytes < throughput_led[i] )
			break;
	}

	ETHER_OUT_LED(i);

	for (i = 0; i < 4; i++) {
		if ( diff_rx_bytes < throughput_led[i] )
			break;
	}

	ETHER_IN_LED(i);

#if 0
	printk("diff tx = %ld, rx = %ld\n", diff_tx_bytes, diff_rx_bytes);
#endif

	init_timer(&ethled_timer);
	ethled_timer.function = ethled_callback;
	ethled_timer.expires = jiffies + HZ / 10;
	add_timer(&ethled_timer);
}

void ethled_init(struct net_device_stats *net_stats)
{
	wan_stats = net_stats;

	init_timer(&ethled_timer);
	ethled_timer.function = ethled_callback;
	ethled_timer.expires = jiffies + HZ / 10;
	add_timer(&ethled_timer);
}


