/* $Id: tsdb_ether.c,v 1.1.1.1 2004/04/07 08:36:57 louistsai Exp $
 * tsdb_ether.c: Wrapper for OnBoard Ether drivers for Toshiba SDB board.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 */

#include <linux/config.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/netdevice.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/toshiba-boards/tsdb.h>

extern int smc_init(struct net_device *);

static int tsdb_ether_disable;
static int __init tsdb_ether_setup(char *str)
{
	if (strcmp(str, "off") == 0)
		tsdb_ether_disable = 1;
	return 0;
}
__setup("tsdb_ether=", tsdb_ether_setup);

static struct net_device this_device;

int __init tsdb_ether_init(void)
{
	if (!(mips_machgroup == MACH_GROUP_TOSHIBA &&
	      mips_machtype == MACH_TOSHIBA_SDB))
		return -ENODEV;

	/* set here to prevent auto-detection */
	if (tsdb_ether_disable)
		return -ENODEV;
	this_device.base_addr = TSDB_ETHER_ADDR - mips_io_port_base;
	this_device.irq = TSDB_IRQ_LOCAL_ETHER;
	this_device.init = smc_init;
	this_device.if_port = 2; /* TSDB uses AUI SELECT pin as PHY RESET... */
	this_device.mem_end = 0xbad;	/* hack for TSDB... */
	return register_netdev(&this_device);
}

module_init(tsdb_ether_init);
