/* $Id: tx4927evb_ether.c,v 1.1.1.1 2004/04/07 08:36:57 louistsai Exp $
 * tx4927evb_ether.c: Wrapper for OnBoard Ether drivers for TOSHIBA TX4927 EVB board.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */

#include <linux/config.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/netdevice.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/toshiba-boards/tx4927evb.h>

extern int ne_probe(struct net_device *);

static int tx4927evb_ether_disable;
static int __init tx4927evb_ether_setup(char *str)
{
	if (strcmp(str, "off") == 0)
		tx4927evb_ether_disable = 1;
	return 0;
}
__setup("tx4927evb_ether=", tx4927evb_ether_setup);

static struct net_device this_device;

int __init tx4927evb_ether_init(void)
{
	if (!(mips_machgroup == MACH_GROUP_TOSHIBA &&
	      mips_machtype == MACH_TOSHIBA_TX4927EVB))
		return -ENODEV;

	/* set here to prevent auto-detection */
	if (tx4927evb_ether_disable)
		return -ENODEV;
	this_device.base_addr = TX4927EVB_ETHER_ADDR - mips_io_port_base;
	this_device.irq = TX4927EVB_IRQ_IOC_LANC;
	this_device.init = ne_probe;
	return register_netdev(&this_device);
}

module_init(tx4927evb_ether_init);
