#include <linux/fs.h>
#include <linux/ext2_fs_c.h>
#include "e2compr_lzo.h"
#include "lzo1x.h"
#ifdef __KERNEL__
# include <linux/kernel.h>
# include <linux/module.h>
#endif

#if 0
static void *heap_start = NULL;
static u8 *orig_start = NULL;
#endif

#if EXT2_MAX_CLU_NBYTES > (32*1024)
# error "Check that lzo overrun allowance is still correct for this cluster size."
#endif
#define MAGIC_BYTE 42

size_t 
ext2_wLZO (u8 *in_buf, 
	   u8 *out_buf,
	   void *heap,
	   size_t num_in_buf,
	   size_t num_out_buf,
	   int param)
{
	size_t clen;

	MOD_INC_USE_COUNT;
	if (heap == NULL)
		goto err;
	if (((u8 *)heap < out_buf)
	    || ((u8 *)heap > out_buf + EXT2_MAX_CLUSTER_BYTES)) {
#ifdef __KERNEL__
		printk(KERN_WARNING
		       "lzo: heap doesn't seem to be contiguous with out_buf.  orig_start: %p, out_buf: %p, diff: %d.  Returning zero.\n",
			(u8 *)heap, out_buf, (u8 *)heap - out_buf);
#else
		fprintf(stderr,
			"lzo: heap/out_buf misplacement.  "
			"orig_start: %p, out_buf: %p, diff: %d\n",
			heap, out_buf, heap - out_buf);
#endif
		goto err;
	}
	((unsigned char *)heap)[LZO_OVERRUN_LEN] = MAGIC_BYTE;
	if (lzo1x_1_15_compress(in_buf, num_in_buf,
				out_buf, &clen,
				heap + LZO_OVERRUN_LEN + 1))
		clen = 0;
	if (((unsigned char *)heap)[LZO_OVERRUN_LEN] != MAGIC_BYTE) {
		printk(KERN_ERR
		       "lzo: overran allowed area.  Please report to e2compr list.\n");
		goto err; /* play it safe */
	}
	if (clen > num_out_buf)
		goto err;
	MOD_DEC_USE_COUNT;
	return clen;

err:
	MOD_DEC_USE_COUNT;
	return 0;
}

size_t 
ext2_rLZO (unsigned char *in_buf, 
           unsigned char *out_buf,
	   void *heap,
           size_t num_in_buf,
           size_t num_out_buf, /* N.B.: ignored. */
           int param)
{
	int err;

	MOD_INC_USE_COUNT;
#if 0
	if (heap_start == NULL) {
		MOD_DEC_USE_COUNT;
		return 0;
	}

	err = lzo1x_decompress(in_buf, num_in_buf, out_buf, &num_out_buf,
		heap_start);
#else
	err = lzo1x_decompress(in_buf, num_in_buf, out_buf, &num_out_buf, heap);
#endif
	if (err != LZO_E_OK) {
		printk(KERN_WARNING
		       "lzo1x_decompress() returned %d.\n", err);
		MOD_DEC_USE_COUNT;
		return 0;
	}
	MOD_DEC_USE_COUNT;
	return num_out_buf;
}

size_t 
ext2_iLZO (int action)
{
	/* The compressor can overrun its output buffer by 531 bytes
	   (LZO_OVERRUN_LEN).  We use the 532nd byte to hold a magic
	   number (which we check to detect overruns of the overrun
	   buffer).  128KB is the working memory for _15.
		orig_start_C = (u8 *) mem_start;
		heap_start_C = orig_start_C + LZO_OVERRUN_LEN + 1;
	*/
	switch (action) {
		case EXT2_ALG_INIT_COMPRESS:
			return (128 * 1024) + LZO_OVERRUN_LEN + 1;
		case EXT2_ALG_INIT_DECOMPRESS:
			return 0;
		default:
			return 0;
	}
}

#ifdef MODULE

int init_module(void)
{
	struct ext2_algorithm lzo_alg;

	lzo_alg.name = NULL;
	lzo_alg.avail = 1;
	lzo_alg.init = ext2_iLZO;
	lzo_alg.compress = ext2_wLZO;
	lzo_alg.decompress = ext2_rLZO;

	return ext2_register_compression_module(EXT2_LZO_ALG, 
			(128 * 1024) + LZO_OVERRUN_LEN + 1,
			0,
			&lzo_alg);
}

void cleanup_module(void)
{
	ext2_unregister_compression_module(EXT2_LZO_ALG);
}

#endif
