#include <linux/fs.h>
#include <linux/ext2_fs_c.h>
#include <linux/types.h>
#include <linux/module.h>
#include "lzv1.h"

size_t ext2_iLZV1 (int action)
{
	switch (action) {
		case EXT2_ALG_INIT_COMPRESS:
			return HSIZE * sizeof (unsigned short);
		case EXT2_ALG_INIT_DECOMPRESS:
			return 0;
		default:
			return 0;
	}
}

size_t ext2_wLZV1 (unsigned char *in, unsigned char *out, void *heap, size_t len, size_t out_len, int xarg)
{
	int ret_code;

	MOD_INC_USE_COUNT;
	ret_code = ext2_LZV1_compress(in, out, heap, len, out_len);
	MOD_DEC_USE_COUNT;
	return ret_code;
}

size_t ext2_rLZV1 (unsigned char *in, unsigned char *out, void *heap, size_t ilen, size_t len, int xarg)
{
	int ret_code;

	MOD_INC_USE_COUNT;
	ret_code = ext2_LZV1_decompress(in, out, ilen, len);
	MOD_DEC_USE_COUNT;
	return ret_code;
}

#ifdef MODULE

int init_module(void)
{
	struct ext2_algorithm lzv_alg;

	lzv_alg.name = NULL;
	lzv_alg.avail = 1;
	lzv_alg.init = ext2_iLZV1;
	lzv_alg.compress = ext2_wLZV1;
	lzv_alg.decompress = ext2_rLZV1;

	return ext2_register_compression_module(EXT2_LZV1_ALG,
			HSIZE * sizeof(unsigned short),
			0,
			&lzv_alg);
}

void cleanup_module(void)
{
	ext2_unregister_compression_module(EXT2_LZV1_ALG);
}

#endif

