/* 
   (This document isn't finished, but it does include the most 
   important information.)

   This file hopes to give some documentation on how to add a new 
   compression method to e2compr.

   LZO looks like a good method to add, for example.  (Good for files
   that are usually accessed when CPU already fully loaded.)


   Requirements
   ============

   You need to know how much memory is needed.  (You get a pointer to
   a large area of memory before you start to compress or decompress.
   You need to know in advance -- i.e. at compile time -- how big you
   need this area to be.)

   You need to check that your routines don't use recursion or
   anything else likely to use large amounts of stack space.

   For future compatibility, you should try to make the routines re-entrant.
   E.g. for all variables that are either at file scope or are declared static,
   expect that they can be clobbered whenever you call schedule().
   One way of dealing with this would be to move the variables to the heap
   (remembering to increase your heap size requirement declaration);
   another is to store local (i.e. stack space) copies of such vars.
   At the moment, the most likely sort of reentrancy requirement is that
   compression and decompression must be able to happen simultaneously.
   So the most important thing is vars that are common to your compression
   and decompression routines.

   Write wrapper functions that conform to the interface that the
   kernel expects.  Namely, you're given a pointers to two 32KB areas
   (one for the input data, one for the output data; or put another
   way, one for compressed data and one for uncompressed data), a
   pointer to a large area of memory for your own use, you're told how
   long the input data is, how long the output data is expected to be.
   You must never write past the end of the 32KB output buffer, or
   write to the input buffer.
   
   (If, for performance reasons, you think you may overrun the output
   buffer by no more than a known amount: the heap and buffers are
   next to each other, so you may be able to organise that overruns go
   into the heap, and not use the first n bytes of the heap for
   anything else.)
   
   Return zero if there is an error, or if the data can't be compressed; 
   otherwise return the length of the output data.

   More details follow.


   Memory allocation
   -----------------

   There are several sources of memory:

   + A large area (about 256KB, or however much hou say you need) of 
     contiguous memory is made available to you.  This area is generally 
     known as the "heap".
     
     You are encouraged to use the heap for most of your memory requirements, 
     as it remains allocated whether or not you use it.  
     
     Data put here is not retained between invocations of your 
     functions.
     
   + Stack space.  (This is what C uses for its automatic
     (i.e. non-static) variables.)  Do not use much of this!  In
     kernel space, there is only a page or two (I think that in 2.1
     and later, it\'s two pages less ~1.5KB; and one page or less in
     2.0 and earlier; a page is 4096 bytes on most machines) of stack
     space per process.  This effectively rules out recursion in any
     of your routines.  It also means that you can't have large arrays
     as automatic (non-static) variables.



   Interface:

   There are three entry functions: a simple initialisation function,
   a decompression function, and a compression function.

   The initialisation function is to organise an area of memory for
   you.

     int ext2_iFOO (void *mem_start, int action);

   The first time it's called is by fs/ext2/super.c, the first time an
   ext2 filesystem is mounted (which is usually at boot time).
   super.c wants to know how much memory (measured in bytes) you'll
   need in this area.  (gzip requires 200KB; I think one of the others
   requires 256KB.)  super.c passes NULL for mem_start.

   Subsequently it's called by fs/ext2/compress.c (search for
   `.init'), which passes you a pointer to an area of memory at least
   as big as you told super.c that you need.  Assign this value to a
   static variable (at file scope) so that your compression and
   decompression routines know where the heap is.
   
   The 'int action' parameter tells your function what's going on, i.e.
   if it has to initialize algorithm for compression or decompression -
   this is important for simultaneous compression/decompression.

   Changes to rest of e2compr code:

   + Decide on a short identifier.  In these instructions I've used `foo'.
     Check that your chosen identifier isn't used elsewhere by doing:

       find /usr/src/linux/. -name '*.[ch]'|xargs grep -i foo

     or some such.

   + If you only have one new file to add to the source tree, call it
     `fs/ext2/foo.c'.  Add foo.c to the definition of COMPRESS_STUFF
     in fs/ext2/Makefile.

     Otherwise `mkdir fs/ext2/foo', and put a Makefile in it.  If you
     have .S files, lzrw/Makefile (see the separate LZRW patch on
     <http://e2compr.memalpha.cx/e2compr/software-04x.html#lzrw>) is a 
     good starting point, otherwise gzip/Makefile.  Add foo to the 
     definition of SUB_DIRS in fs/ext2/Makefile.

   + Edit fs/Config.in.  Search for `LZV' (there should be two such
     lines), duplicate each line, and change LZV to FOO.

   + You will need three entry functions.  I suggest you call them
     ext2_iFOO(), ext2_rFOO() and ext2_wFOO().
     
     The `i' function is the initialisation function.  It is called by
     fs/ext2/super.c (which wants to know how much memory to allocate
     for you, and which passes NULL as the parameter) and it is called
     before your de/compression routines are called, to give you the
     starting address of the heap.

   * A good way of testing your routines is to link them into
     e2compress before into the kernel, just so that you get the
     benefit of memory- and crash-protection and of not having to
     reboot the machine to change your code.  Change the Makefile in
     src/e2compress, edit e2compress.c, search for `gzip' (ignoring
     case), follow the pattern.

   + Edit fs/ext2/compress.c.  Search for `GZIP'.  Follow the pattern
     for the the other algorithms there.  (I.e. #undef FOO, #define
     FOO to 1 or 0 according to whether or not CONFIG_EXT2_HAVE_FOO is
     defined.)

     Add an entry to ext2_algorithm_table[].  (Or rather, change one
     of the entries with `0' in the second column.)  Again, follow the
     existing pattern.

   + Edit include/linux/ext2_fs.h and include/linux/ext2_fs_c.h.
     Search for `GZIP' and follow the pattern.



   */

#include <linux/types.h>

/* Your code needs to be able to be compiled into e2compress(1), so make sure
   that kernel-specific things are wrapped in `#ifdef __KERNEL__'. */
#ifdef __KERNEL__
# include <linux/linkage.h>
# include <asm/param.h>
/* If you want your code to be able to be compiled as module add those
 * two includes
 */
# include <linux/ext2_fs_c.h>
# include <linux/module.h>
asmlinkage void schedule(void);
static unsigned long next_brk = 0;
extern unsigned long volatile jiffies;
#endif

size_t ext2_iFOO (void *ptr, int action)
{
	switch (action) {
		case EXT2_ALG_INIT_COMPRESS:
			return 0;
		case EXT2_ALG_INIT_DECOMPRESS:
			return 0;
		default:
			return 0;
	}
}

size_t ext2_rFOO (__u8 *ibuf, __u8 *obuf, size_t ilen, size_t olen, int xarg)
{
  /* I've never noticed decompression to be a speed problem, so
     I don't bother calling schedule() from here. */

  /* If you want your code to be able to be compiled as module add this code */
  MOD_INC_USE_COUNT;
  /* do decompression */
  /* If you want your code to be able to be compiled as module add this code */
  MOD_DEC_USE_COUNT;
  return 0;
}

size_t ext2_wFOO (__u8 *ibuf, __u8 *obuf, size_t ilen, size_t olen, int xarg)
{
  /* If you want your code to be able to be compiled as module add this code */
  MOD_INC_USE_COUNT;
  for(;;)
    {
      /* Preferably put this bit in a place that's only executed
         rarely rather than once per byte processed... */
#ifdef __KERNEL__
      /* Time slice of a fifth of a second. */
      if (jiffies > next_brk)
	{
	  schedule();
	  next_brk = jiffies + HZ / 5;
	}
#endif
    }
  /* If you want your code to be able to be compiled as module add this code */
  MOD_DEC_USE_COUNT;
  return 0; /* never reached */
}

/* If you want your code to be able to be compiled as module add this code */
#ifdef MODULE

int init_module(void)
{
	struct ext2_algorithm foo_alg;

	foo_alg.name = NULL;
	foo_alg.avail = 1;
	foo_alg.init = ext2_iFOO;
	foo_alg.compress = ext2_wFOO;
	foo_alg.decompress = ext2_rFOO;

	return ext2_register_compression_module(EXT2_FOO_ALG,
			0, /* AMOUNT OF REQUIRED MEMORY FOR COMPRESSION */
			0, /* AMOUNT OF REQUIRED MEMORY FOR DECOMPRESSION */
			&foo_alg);
}

void cleanup_module(void)
{
	ext2_unregister_compression_module(EXT2_FOO_ALG);
}

#endif

