/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		mconfig.h
*
*	Abstract: 
*		header file for MCT configuration library
*		
*	HISTORY:
*		2001/12/1	Ethan Wang Created
*		2002/1/21	Louis Tsai Added
*	COMMENT:
*		MAX_XXX		represents the maximun value of some variable
*		EN_XXX		represents to enable some feature
*		
*********************************************************************************/

#ifndef __ASM_MCONFIG_H__
#define __ASM_MCONFIG_H__

// The next include file should be specified instead of <linux/types.h>
// because it will generate "redefinition" error message.
#include <asm/types.h>

#ifdef __KERNEL__

#include <linux/time.h>

#if defined(CONFIG_MCT_SG100)
#define SG100
#elif defined(CONFIG_MCT_SG600)
#define SA100
#elif defined(CONFIG_MCT_SG4100)
#define SG4100
#elif defined(CONFIG_MCT_SA100)
#define SA100
#endif

#else
#include <time.h>
#endif	// __KERNEL__


#ifndef MCT_ES
#undef 	TRUE
#undef 	FALSE
enum { FALSE = 0, TRUE = 1};
typedef unsigned char	BOOL;
#endif

// define IP address in network order.
#define IPADDR(a, b, c, d)	((a) | (b << 8) | (c << 16) | (d << 24))

#define USER_NAME_LEN		21
#define GROUP_NAME_LEN		21
#define USER_PASSWD_LEN		11
#define MAX_GROUP_NUM		512
#define MAX_USER_NUM		200

#define HOST_NAME_SIZE		64
#define DOMAIN_NAME_SIZE	30
#define IPSEC_ID_SIZE		10

#define URL_NAME_SIZE		64
#define CONN_NAME_SIZE		20
#define PPPOE_USERNAME_LEN	48
#define PPPOE_PASSWORD_LEN	12
#define PPTP_USERNAME_LEN	PPPOE_USERNAME_LEN
#define PPTP_PASSWORD_LEN	PPPOE_PASSWORD_LEN
#define SMB_PRINTER_NAME_SIZE	32
#define SMB_SERVER_STRING_SIZE	32
#define SMB_WORKGROUP_SIZE	32
#define ADMIN_PASSWORD_LEN	30
#define DDNS_USERNAME_LEN	30
#define DDNS_PASSWORD_LEN	30

// DEFINE MAXIMUN SYSTEM NUMBERS
#define MAX_DHCP_RANGE_LISTS	10
#define MAX_MACMAPPING_SIZE	20
#define MAX_HOSTMAPPING_SIZE	20
#define MAX_IPSEC_CONNECTIONS	20
#define MAX_VSERVER_RULES	10
#define MAX_DHCP_LEASES_RECORDS	((0x4000-8)/sizeof(REG_IP_LEASES))	
#define MAX_URL_ACCESS_RULES	10
#define MAX_IP_ACCESS_GROUPS	5
#define MAX_LOGS_LENGTH		120
#define MAX_LOGS_NUM		60
#define MAX_ROUTE_SIZE		5

/* type of external interface interface */
enum {
	PUBIF_PPPOE = 1,
	PUBIF_PPTPC,
	PUBIF_DHCPC,
	PUBIF_FIXED,
};

#define SYSIMAGE_ADDR		0x00020000
#define SYSIMAGE_SECTOR_SIZE	(64*1024)

/* system image state */
#define SI_NORMAL	0
#define SI_LOADING	1
#define SI_LOADED	2
#define SI_WRITING	3
#define SI_COMPLETED	4
#define SI_ERROR	5
#define SI_BOOT_LOADED  6

/* error level of event log */
enum {
	LEVEL_NORMAL,
	LEVEL_WARNING,
	LEVEL_URGENT,
};

/* ipsec remote host type */
enum {
	IPSEC_REMOTE_FIXEDIP,
	IPSEC_REMOTE_DYNAMICIP,
	IPSEC_REMOTE_CLIENT,
};

/* interface token for static route */
enum {
	WAN_INTERFACE,
	LAN_INTERFACE,
};

typedef struct {
	char	hostname[20];
	unsigned char chaddr[6];
	__u32	yiaddr;
	__u32	expires;
} DHCP_OFFERED_ADDR;

typedef struct {
	unsigned int	state;
	unsigned char	percentage;
} FIRMWARE_STATUS;

/* FIRST ARGUMENT TYPE OF "READ_CONFIG" AND "WRITE_CONFIG" */
enum {
	MC_NET_CONFIG,
	MC_IPALIAS_CONFIG,
	MC_MNAT_CONFIG,
	MC_DHCP_CONFIG,
	MC_DHCP_LEASE,
	MC_MACMAPPING_CONFIG,
	MC_HOSTMAPPING_CONFIG,
	MC_ROUTE_CONFIG,
	MC_PPPOE_CONFIG,
	MC_IPSEC_CONFIG,
	MC_PPTP_CONFIG,
	MC_VSERVER_CONFIG,
	MC_IP_ACCESS_CONFIG,
	MC_URL_ACCESS_CONFIG,
	MC_ANTIHACK_CONFIG,
	MC_SAMBA_CONFIG,
	MC_ALARM_CONFIG,
	MC_ADMIN_CONFIG,
	MC_DDNS_CONFIG,
	MC_SNMP_CONFIG,
	MC_USER_CONFIG,
	MC_EVENTLOG_CONFIG,

	MC_GET_FWVER,
	MC_RESET_CONFIG,	// reset to factory settings.

	MC_UPDATE_SYSTEM_START,
	MC_UPDATE_SYSTEM,
	MC_UPDATE_SYSTEM_END,
	
	MC_UPDATE_STATUS,

	MC_EVENTLOG_GET_CNT,
	MC_EVENTLOG_GET,
	MC_EVENTLOG_ADD,
	MC_EVENTLOG_CLEAR,

	MC_DHCP_ADD_LEASE,
	MC_DHCP_FIND_LEASE_BY_CHADDR,
	MC_DHCP_FIND_LEASE_BY_YIADDR,
	MC_DHCP_CLEAR_LEASE,
//#if defined(SG600) || defined(NAS100) || defined(SA100)
	MC_USER,
	MC_GROUP,
	MC_SHARE,
//	MC_USERSHARE,	// update user & group & share block at the same time
	MC_NFS_CONFIG,
	MC_IDESMART_CONFIG,
	MC_MAIL_CONFIG,
	MC_W3S_CONFIG,
	MC_TIMEZONE_CONFIG,
	MC_UPDATE_ALL_PID_TIMEZONE,
//#endif
	MC_POWER_DOWN,
	MC_SWITCH_STATUS,
	MC_DEFAULT_USR_GRP_SHARE,
	MC_START_HEARTBEAT,
	MC_FTP_PORT,
	MC_UPNP_DEVICE_CONFIG,
	MC_UPNP_MMS_CONFIG,
	MC_RWMEM,
	MC_BPA_CONFIG,
	MC_PPPOE_MTU,
};

enum {
	IDS_SYSTEM_START,	
	IDS_DHCPC_NO_LEASE,
	IDS_DHCP_COLLISION,
	IDS_DHCP_AUTO_ADD_NEW_RANGE, // prevent no legal ip from being assigned to client 
	IDS_DOS_ATTACK,
	IDS_IPSEC_CONFLICTING_SETTING,

	IDS_EVENTLOG_NORMAL = 100,
	IDS_EVENTLOG_WARNING,
	IDS_EVENTLOG_URGENT,
	IDS_ONLINE,
	IDS_OFFLINE,
	IDS_CONNECT,
	IDS_DISCONNECT,
	IDS_DYNAMIC,
	IDS_PASS,
	IDS_FAIL,
	IDS_NOT_SUPPORT,
	IDS_DISABLE,
	IDS_UNMOUNTING,
	IDS_MOUNTING,		
	IDS_SCANNING,	
	IDS_FORMATTING,
	IDS_READY,
	IDS_IOERR,
	IDS_MOUNTERR,
	IDS_UNINITIAL,
};


typedef struct {
	unsigned long	dest_addr;
	unsigned int	size;
	unsigned char 	*buf;
} MEM_ACCESS;

typedef struct {
	unsigned int	speed[4];
	unsigned int	full_duplex[4];
	unsigned int	linkup[4];
} SWITCH_STATUS;

/*BASIC NETWORK CONFIGURATION DATA STUCTURE*/
typedef struct {
	BOOL	enable_nat;
	char	hostname[HOST_NAME_SIZE];
	__u32	private_ip, private_netmask;
	__u32 	dns0, dns1, dns2;
	int	public_if;

	// Fixed IP
	__u32	public_ip, public_netmask;
	__u32	gateway;

	// DHCP Client
	__u8	mac[6];

	// PPPoE related settings
	BOOL	demand;
	char	username[PPPOE_USERNAME_LEN];
	char	password[PPPOE_PASSWORD_LEN];
	int	idle;

	// PPTP Client
	char	pptp_username[PPTP_USERNAME_LEN];
	char	pptp_password[PPTP_PASSWORD_LEN];
	__u32	my_ip;
	__u32	remote_ip;
} REG_NET_CONF __attribute__ ((packed));

typedef struct {
	__u32	alias_ip0, alias_netmask0;
	__u32	alias_ip1, alias_netmask1;
	__u32	alias_ip2, alias_netmask2;
} REG_IPALIAS_CONF __attribute__ ((packed));

typedef struct {
	__u32   mnat_in_ipstart0,mnat_in_ipstart1;
	__u32   mnat_ext_ipstart0,mnat_ext_ipstart1;
	__u8	mnat_in_nm0, mnat_in_nm1;
	__u8	mnat_ext_end0, mnat_ext_end1;
} REG_MNAT_CONF __attribute__ ((packed));

/*DHCP CONFIGURATION DATA STUCTURE*/

typedef struct {
	BOOL	enable;
	__u32	wins;
	int	lease_time;		/* max. lease time */
	int	min_lease_time;		/* min. lease time (obsolete field) */
	char 	domain_name[DOMAIN_NAME_SIZE];
	__u32	range_start0, range_end0;
	__u32	range_start1, range_end1;
	__u32	range_start2, range_end2;
	__u32	range_start3, range_end3;
} REG_DHCP_CONF __attribute__ ((packed));

typedef struct {
	__u32	ip;
	time_t	start, end;
	unsigned char mac[6];
	char	hostname[20];
} REG_IP_LEASES __attribute__ ((packed));

typedef struct {
	int 	lease_count;
	REG_IP_LEASES item[MAX_DHCP_LEASES_RECORDS];
} REG_DHCP_LEASE __attribute__ ((packed));

typedef struct {
	unsigned char hwaddr[6];
	__u32	ipaddr;
} REG_MACMAPPING_TABLE;

typedef struct {
	int	count;
	REG_MACMAPPING_TABLE table[MAX_MACMAPPING_SIZE];
} REG_MACMAPPING_CONF;

typedef struct {
	char	hostname[20];
	__u32	ipaddr;
} REG_HOSTMAPPING_TABLE;

typedef struct {
	int	count;
	REG_HOSTMAPPING_TABLE table[MAX_HOSTMAPPING_SIZE];
} REG_HOSTMAPPING_CONF;

typedef struct {
	__u32	dest_ip;
	__u32	gateway;
	__u8	dest_cidr;
	__u8	metric;
	__u8	interface;	// unused 
} REG_ROUTE_ITEM;

typedef struct {
	BOOL	enable;
	REG_ROUTE_ITEM	route_entry[MAX_ROUTE_SIZE];
} REG_ROUTE_CONF;

/*IPSEC CONFIGURATION*/
typedef struct {
	char	name[CONN_NAME_SIZE]; 	//connection name
	char	remote_id[IPSEC_ID_SIZE];
	__u32	remote_gw;		//remote gateway
	__u32	remote_subnet;		//remote subnet ip
	__u32	remote_nm;		//remote subnet mask
	int	remote_type;		//0: fixed ip gw , 1: dynamic ip gw , 2: client 
	char	secret_key[65];		//128-bits encrypted
	unsigned int keylife;		//key life
	BOOL	bootup;			//established connection while system boot
} REG_IPSEC_CONNECTION_ITEM __attribute__ ((packed));

typedef struct {
	BOOL	enable;
	int  	conn_count;
	char 	host_id[IPSEC_ID_SIZE];
	REG_IPSEC_CONNECTION_ITEM conn[MAX_IPSEC_CONNECTIONS]; // allow 20 ipsec connections
} REG_IPSEC_CONF __attribute__ ((packed));

typedef struct {
	BOOL	enable;
	unsigned char serverip,startip,endip;   /*added by louistsai 2003/1/2*/
} REG_PPTP_CONF __attribute__ ((packed));

/* VIRTUAL SERVER CONFIGURATION*/
typedef struct {
	char 	protocol; // 0:TCP , 1:UDP , 2:BOTH
	__u16	port_end;
	__u16 	port;
	__u32	redirect_ip;	
} REG_VSERVER_POLICY __attribute__ ((packed));

typedef struct {
	BOOL	enable;
	REG_VSERVER_POLICY	rule[MAX_VSERVER_RULES];
} REG_VSERVER_CONF __attribute__ ((packed));

/*URL ACCESS CONFIGURATION*/

typedef struct {
	BOOL	enable;
	BOOL	access; 	// unused 
	char url[MAX_URL_ACCESS_RULES][URL_NAME_SIZE];
} REG_URL_ACCESS_CONF __attribute__ ((packed));

/*IP_ACCESS_CONFIGURATION*/
typedef struct {
	__u32	ip;
	int	CIDR_mask_no;
	int	block_port[4];
	int	block_range_start,block_range_end;
	char	proto; // 0:TCP , 1: UDP , 2:ALL
} REG_ACCESS_RULE __attribute__ ((packed));

typedef struct {
	BOOL 	enable;
	REG_ACCESS_RULE rule[MAX_IP_ACCESS_GROUPS];	
} REG_IP_ACCESS_CONF __attribute__ ((packed));

/*SAMBA & PRINTER CONFIGURATION*/
typedef struct {
	char 	workgroup[SMB_WORKGROUP_SIZE];
	char 	printer_name[SMB_PRINTER_NAME_SIZE];
	char 	server_string[SMB_SERVER_STRING_SIZE];
} REG_SAMBA_CONF __attribute__ ((packed));

/*ANTI-HACK CONFIGURATION*/
typedef struct {
	int	syn_limit, icmp_limit, udp_limit;		// per second to be acceptable for gatway!
	BOOL	enable;					// firewall enable
	BOOL	EN_SYNFLOOD, EN_ICMPFLOOD, EN_UDPFLOOD;   // Limit the number of TCP SYN,ICMP,UDP requests
	BOOL	EN_PING_DEATH;	
	BOOL	EN_IP_SPOOF;
	BOOL	EN_PORT_SCAN;
	BOOL	EN_TEAR_DROP;	
} REG_ANTIHACK_CONF __attribute__ ((packed));

typedef struct {
	BOOL 	enable;
	char 	server[64];
	char 	admin_email[256];
	int  	alarm_level;       
} REG_ALARM_CONF __attribute__ ((packed));

typedef struct {
	char	password[ADMIN_PASSWORD_LEN];
	BOOL	enable_ext;
	int	ext_webport;
} REG_ADMIN_CONF __attribute__ ((packed));


enum {
	DDNS_DHS = 0,
	DDNS_DYNDNS,
	DDNS_DYNS,
	DDNS_EASYDNS,
	DDNS_JUSTLINUX,
	DDNS_ODS,
	DDNS_PGPOW,
	DDNS_TZO,
};
// unused structure
typedef struct {
	BOOL	enable;
	char	service_type; //0:DHS 1:DYNDNS 2:DYNS 3:EASYDNS 4:JUSTLINUX
			      //5:ODS 6:PGPOW 7:TZO
	char	username[DDNS_USERNAME_LEN];
	char	password[DDNS_PASSWORD_LEN];
	char	hostname[HOST_NAME_SIZE];
} REG_DDNS_CONF __attribute__ ((packed));

#define MAX_SNMP_COMMUNITY_LEN 20
#define MAX_SNMP_CONTACT_LEN 32
#define MAX_SNMP_LOCATION_LEN 32
typedef struct {
	BOOL	enable;	
	char 	community[MAX_SNMP_COMMUNITY_LEN];
	char 	contact[MAX_SNMP_CONTACT_LEN];
	char 	location[MAX_SNMP_LOCATION_LEN];
} REG_SNMP_CONF __attribute__ ((packed));


#define MAX_NFS_MOUNTS 200

typedef struct {
	int	local_uid,remote_uid;
	__u32	remote_ip;
	__u8	mask_no;
	__u8	type;
} REG_NFS_CONF_ITEM __attribute__ ((packed));

typedef struct {
	BOOL enable;	
	int count;
	REG_NFS_CONF_ITEM nfs_item[MAX_NFS_MOUNTS];
} REG_NFS_CONF __attribute__ ((packed));

typedef struct {
	__u8	local_uid,remote_uid;
	__u32	remote_ip;
	__u8	mask_no;
	__u8	type;
} OLD_REG_NFS_CONF_ITEM __attribute__ ((packed));

typedef struct {
	BOOL enable;	
	int count;
	OLD_REG_NFS_CONF_ITEM nfs_item[MAX_NFS_MOUNTS];
} OLD_REG_NFS_CONF __attribute__ ((packed));


typedef struct {
	BOOL enable;
	unsigned char stimer;
} REG_IDESMART_CONF __attribute__ ((packed));



typedef struct {
	  char name[USER_NAME_LEN];
	  char passwd[USER_PASSWD_LEN];
	  unsigned char pptp_ip_offset; /* added by louistsai 2003/1/2 */
} USER_INFO __attribute__ ((packed));

typedef struct {
	int	count;
	USER_INFO user[MAX_USER_NUM];
} REG_USER_CONF __attribute__ ((packed));

#define collision_ip	u.uevent_collision_ip
//#define vpn_conn_id	u.vpn_conn_id

typedef struct {
	unsigned char	level;	
	unsigned char	msgid;
	unsigned int	time;
	union {
		__u32	uevent_collision_ip;
		__u8	vpn_conn_id;
	} u;
} EVENTLOG_ENTRY __attribute__ ((packed));

typedef struct {
	int	head, tail;
	EVENTLOG_ENTRY	eventlog[MAX_LOGS_NUM];
} REG_EVENTLOG_CONF __attribute__ ((packed));

#define MAX_MAIL_DOMAIN_NAME	100
typedef struct {
	BOOL 	enable;
	char 	domain_name[MAX_MAIL_DOMAIN_NAME];
	int	user_quota,max_mail_size;
} REG_MAIL_CONF __attribute__ ((packed));

typedef struct {
	BOOL 	enable;
	int	port_num;
} REG_W3S_CONF __attribute__ ((packed));

typedef struct {
	BOOL 	enable;
	char 	username[32];
	char 	passwd[64];
} REG_BPA_CONF __attribute__ ((packed));



/* block definition without checksum */
typedef struct {
	REG_NET_CONF 		net_conf;
	REG_IPALIAS_CONF	ipalias_conf;
	REG_MNAT_CONF		mnat_conf;	
	REG_DHCP_CONF 		dhcp_conf;
	REG_MACMAPPING_CONF	macmapping_conf;
	REG_HOSTMAPPING_CONF	hostmapping_conf;
	REG_ROUTE_CONF		route_conf;
	REG_VSERVER_CONF 	vserver_conf;
	REG_IP_ACCESS_CONF 	ip_access_conf;
	REG_URL_ACCESS_CONF 	url_access_conf;
	REG_IPSEC_CONF		ipsec_conf;
	REG_PPTP_CONF		pptp_conf;
	REG_SAMBA_CONF		smbprn_conf;
	REG_ANTIHACK_CONF	antihack_conf;
	REG_ALARM_CONF		alarm_conf;
	REG_ADMIN_CONF		admin_conf;
	REG_DDNS_CONF		ddns_conf;
	REG_SNMP_CONF		snmp_conf;
//#if defined(SG600) || defined(NAS100) || defined(SA100)
	REG_IDESMART_CONF	idesmart_conf;	
	OLD_REG_NFS_CONF	nfs_conf;
//#endif
} GENCONF_BLOCK;

typedef struct {
	REG_USER_CONF		useraccount_conf;
} USERACCOUNT_BLOCK;

typedef struct {
	REG_NFS_CONF		nfs_conf;
	REG_MAIL_CONF		mail_conf;
	REG_W3S_CONF		w3s_conf;
	int			time_zone;
	int			upnp_device_enable;
	int			upnp_mms_enable;
	int			ftp_port_num;
	REG_BPA_CONF		bpa_conf;
	int			pppoe_mtu;
} EXTCONF_BLOCK;


typedef struct {
	REG_DHCP_LEASE 		dhcplease_conf;
} DHCPLEASE_BLOCK;

typedef struct {
	REG_EVENTLOG_CONF	eventlog_conf;
} EVENTLOG_BLOCK;

/* block definition with checksum */
typedef struct {
	GENCONF_BLOCK		genconf_block;
	unsigned int		cksum;
} GENCONF_CKSUM_BLOCK;

typedef struct {
	USERACCOUNT_BLOCK	useraccount_block;
	unsigned int		cksum;
} USERACCOUNT_CKSUM_BLOCK;

typedef struct {
	EXTCONF_BLOCK		extconf_block;
	unsigned int		cksum;
} EXTCONF_CKSUM_BLOCK;


typedef struct {
	DHCPLEASE_BLOCK		dhcplease_block;
	unsigned int		cksum;
} DHCPLEASE_CKSUM_BLOCK;

typedef struct {
	EVENTLOG_BLOCK		eventlog_block;
	unsigned int		cksum;
} EVENTLOG_CKSUM_BLOCK;

//previous user database ,remain here for back compatible 


#define MAX_USERS			256
#define MAX_PASSWORD_LEN		20
#define MAX_USERNAME_LEN		21
#define MAX_GROUPS			256
#define	MAX_GROUPNAME_LEN	 	21
#define MAX_SHARENAME_LEN	 	13
#define MAX_SHARES		 	50
#define MAX_WORKGROUP_NAME_LEN	 	16
#define MAX_COMPUTER_DESCRIPTION 	41

#define MCT_E2FSCK_SCANNING	1
#define MCT_E2FSCK_COMPLETE	0
#define MCT_E2FSCK_CANNOT_FIX	-1
#define MCT_E2FSCK_NO_DEVICE	-2

#define MCT_HDINIT_PARTITION 	1
#define MCT_HDINIT_FORMATTING 	2
#define MCT_HDINIT_COMPLETE	3

#define MCT_E3FORMAT_SHMID	7878

typedef struct {
	unsigned char status;
	int	percent;
} MCT_HD_PROGRESS;

typedef struct {
	char	name[MAX_USERNAME_LEN];
	char	password[MAX_PASSWORD_LEN];
	__u8	uid;
} USER_DATA __attribute__ ((packed));

typedef struct {
	__u32	bitstr[8];	//each bit indicates whether each one buffer in array have been used
	__u32	pptp_on[8];	//
	USER_DATA	usrdata[MAX_USERS];
} USERS __attribute__ ((packed));

typedef struct {
	char	name[MAX_GROUPNAME_LEN];
	__u8	gid;
	__u32	members[8];	//used bitstr to represent each member
} GROUP_DATA __attribute__ ((packed));

typedef struct {
	__u32	bitstr[8];	//each bit represents to a unique user ,total 256 bits
	__u32	pptp_on[8];	//
	GROUP_DATA	grpdata[MAX_GROUPS];
} GROUPS __attribute__ ((packed));

typedef struct {
	char	name[MAX_SHARENAME_LEN];
	__u8	attr;
	__u32	r_users[8], r_grps[8];	//used bitstr to represent each member
	__u32	w_users[8], w_grps[8];	//used bitstr to represent each member
} SHARE_DATA __attribute__ ((packed));

typedef struct {
	BOOL		cifs_enable,mac_enable,ftp_enable;
	char		applezone[MAX_WORKGROUP_NAME_LEN]; 			
	__u8		count;
	char		workgrp_name[MAX_WORKGROUP_NAME_LEN];
	char		computer_des[MAX_COMPUTER_DESCRIPTION];
	SHARE_DATA	shadata[MAX_SHARES];
} SHARES __attribute__ ((packed));

typedef struct {
	USERS	users;
	GROUPS	groups;
	SHARES	shares;
} USERSHARE_BLOCK;

typedef struct {
	USERSHARE_BLOCK	usershare_block;
	unsigned int	cksum;
} USERSHARE_CKSUM_BLOCK;


// Definition for Large Account(1024) database

#define LA_MAX_USERS			256	
//#define LA_MAX_GRP_MEMBERS		200

typedef struct {
	char	name[MAX_USERNAME_LEN];
	char	password[MAX_PASSWORD_LEN];
	__u16	uid;
} LA_USER_DATA __attribute__ ((packed));

typedef struct {
	__u32	bitstr[LA_MAX_USERS/32];	//each bit indicates whether each one buffer in array have been used
	__u32	pptp_on[LA_MAX_USERS/32];	//
	LA_USER_DATA	usrdata[LA_MAX_USERS];
} LA_USERS __attribute__ ((packed));

typedef struct {
	char	name[MAX_GROUPNAME_LEN];
	__u8	gid;
	__u32	members[LA_MAX_USERS/32];	//used bitstr to represent each member
} LA_GROUP_DATA __attribute__ ((packed));

typedef struct {
	__u32	bitstr[MAX_GROUPS/32];	//each bit represents to a unique user ,total 256 bits
	__u32	pptp_on[MAX_GROUPS/32];	//
	LA_GROUP_DATA	grpdata[MAX_GROUPS];
} LA_GROUPS __attribute__ ((packed));

typedef struct {
	char	name[MAX_SHARENAME_LEN];
	__u8	attr;
	__u32	r_users[LA_MAX_USERS/32], r_grps[MAX_GROUPS/32];	//used bitstr to represent each member
	__u32	w_users[LA_MAX_USERS/32], w_grps[MAX_GROUPS/32];	//used bitstr to represent each member
} LA_SHARE_DATA __attribute__ ((packed));

typedef struct {
	BOOL		cifs_enable,mac_enable,ftp_enable;
	char		applezone[MAX_WORKGROUP_NAME_LEN]; 			
	__u8		count;
	char		workgrp_name[MAX_WORKGROUP_NAME_LEN];
	char		computer_des[MAX_COMPUTER_DESCRIPTION];
	LA_SHARE_DATA	shadata[MAX_SHARES];
} LA_SHARES __attribute__ ((packed));

typedef struct {
	LA_USERS	users;
} LA_USERS_BLOCK;

typedef struct {
	LA_USERS_BLOCK	users_block;
	unsigned int	cksum;
} LA_USERS_CKSUM_BLOCK;

typedef struct {
	LA_GROUPS	groups;
	LA_SHARES	shares;
} LA_GRPSHARE_BLOCK;

typedef struct {
	LA_GRPSHARE_BLOCK	grpshare_block;
	unsigned int	cksum;
} LA_GRPSHARE_CKSUM_BLOCK;




#endif	// __ASM_MCONFIG_H__
