/*
 *  linux/arch/mips/toshiba-boards/generic/dma.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 *
 */

#ifndef __ASM_TOSHIBA_BOARDS_DMA_H
#define __ASM_TOSHIBA_BOARDS_DMA_H

/* TX3927/TX4927 stype DMA controllers */

/* bits for set_txx927_dma_mode() */
#define TXx927_DMA_CCR_DBINH	0x04000000
#define TXx927_DMA_CCR_SBINH	0x02000000
#define TXx927_DMA_CCR_CHRST	0x01000000
#define TXx927_DMA_CCR_RVBYTE	0x00800000
#define TXx927_DMA_CCR_ACKPOL	0x00400000
#define TXx927_DMA_CCR_REQPL	0x00200000
#define TXx927_DMA_CCR_EGREQ	0x00100000
#define TXx927_DMA_CCR_CHDN	0x00080000
#define TXx927_DMA_CCR_DNCTL	0x00060000
#define TXx927_DMA_CCR_EXTRQ	0x00010000
#define TXx927_DMA_CCR_INTRQD	0x0000e000
#define TXx927_DMA_CCR_INTENE	0x00001000
#define TXx927_DMA_CCR_INTENC	0x00000800
#define TXx927_DMA_CCR_INTENT	0x00000400
#define TXx927_DMA_CCR_CHNEN	0x00000200
#define TXx927_DMA_CCR_XFACT	0x00000100
#define TXx927_DMA_CCR_XFSZ(order)	(((order) << 2) & 0x0000001c)
#define TXx927_DMA_CCR_XFSZ_1B	TXx927_DMA_CCR_XFSZ(0)
#define TXx927_DMA_CCR_XFSZ_1W	TXx927_DMA_CCR_XFSZ(2)
#define TXx927_DMA_CCR_XFSZ_4W	TXx927_DMA_CCR_XFSZ(4)
#define TXx927_DMA_CCR_XFSZ_8W	TXx927_DMA_CCR_XFSZ(5)
#define TXx927_DMA_CCR_XFSZ_16W	TXx927_DMA_CCR_XFSZ(6)
#define TXx927_DMA_CCR_XFSZ_32W	TXx927_DMA_CCR_XFSZ(7)
#define TXx927_DMA_CCR_MEMIO	0x00000002
#define TXx927_DMA_CCR_SNGAD	0x00000001

/* dual address, 1 word size transfer mode */
#define TXx927_DMA_MODE_DUAL_1W	\
	(TXx927_DMA_CCR_INTENE|TXx927_DMA_CCR_INTENT|TXx927_DMA_CCR_XFSZ_1W)
/* Internal I/O, 1 word size transfer mode */
#define TXx927_DMA_MODE_IIO_1W	\
	(TXx927_DMA_CCR_EXTRQ|TXx927_DMA_CCR_INTENE|TXx927_DMA_CCR_INTENT|TXx927_DMA_CCR_XFSZ_1W)

/* bits for get_txx927_dma_status() */
#define TXx927_DMA_STATUS_CHNACT	0x00000100
#define TXx927_DMA_STATUS_ABCHC	0x00000080
#define TXx927_DMA_STATUS_NCHNC	0x00000040
#define TXx927_DMA_STATUS_NTRNFC	0x00000020
#define TXx927_DMA_STATUS_EXTDN	0x00000010
#define TXx927_DMA_STATUS_CFERR	0x00000008
#define TXx927_DMA_STATUS_CHERR	0x00000004
#define TXx927_DMA_STATUS_DESERR	0x00000002
#define TXx927_DMA_STATUS_SORERR	0x00000001

/* chained DMA descriptor */
typedef void* txx927_chdma_desc_t;

struct txx927_dma_ops {
	void (*init_dma)(unsigned int dmanr);
	void (*enable_dma)(unsigned int dmanr);
	void (*disable_dma)(unsigned int dmanr);
	void (*set_dma_mode)(unsigned int dmanr, unsigned int mode);
	void (*set_dma_addr)(unsigned int dmanr, unsigned int sa, unsigned int da);
	void (*set_dma_addr64)(unsigned int dmanr, unsigned long long sa, unsigned long long da);
	void (*set_dma_count)(unsigned int dmanr, unsigned int count);
	void (*set_dma_inc)(unsigned int dmanr, unsigned int sai, unsigned int dai);
	int (*get_dma_residue)(unsigned int dmanr);
	unsigned int (*get_dma_status)(unsigned int dmanr);
	void (*clear_dma_status)(unsigned int dmanr);
	int (*get_dma_irqno)(unsigned int dmanr);
	/* for chain operation */
	void (*set_dma_chain)(unsigned int dmanr, txx927_chdma_desc_t cha);
	txx927_chdma_desc_t (*get_dma_chain)(unsigned int dmanr);
	void (*set_chdma_mode)(txx927_chdma_desc_t desc, unsigned int mode);
	void (*set_chdma_addr)(txx927_chdma_desc_t desc, unsigned int sa, unsigned int da);
	void (*get_chdma_addr)(txx927_chdma_desc_t desc, unsigned int *sa, unsigned int *da);
	void (*set_chdma_addr64)(txx927_chdma_desc_t desc, unsigned long long sa, unsigned long long da);
	void (*get_chdma_addr64)(txx927_chdma_desc_t desc, unsigned long long *sa, unsigned long long *da);
	void (*set_chdma_count)(txx927_chdma_desc_t desc, unsigned int count);
	void (*get_chdma_count)(txx927_chdma_desc_t desc, unsigned int *count);
	void (*set_chdma_inc)(txx927_chdma_desc_t desc, unsigned int sai, unsigned int dai);
	void (*set_chdma_chain)(txx927_chdma_desc_t desc, txx927_chdma_desc_t cha);
	txx927_chdma_desc_t (*get_chdma_chain)(txx927_chdma_desc_t desc);
	txx927_chdma_desc_t (*alloc_chdma_cmd)(void);
	void (*free_chdma_cmd)(txx927_chdma_desc_t desc);
};
extern struct txx927_dma_ops *txx927_dma_ops;

#define init_txx927_dma(dmanr) \
	(*txx927_dma_ops->init_dma)(dmanr)
#define enable_txx927_dma(dmanr) \
	(*txx927_dma_ops->enable_dma)(dmanr)
#define disable_txx927_dma(dmanr) \
	(*txx927_dma_ops->disable_dma)(dmanr)
#define set_txx927_dma_mode(dmanr, mode) \
	(*txx927_dma_ops->set_dma_mode)(dmanr, mode)
#define set_txx927_dma_addr(dmanr, sa, da) \
	(*txx927_dma_ops->set_dma_addr)(dmanr, sa, da)
#define set_txx927_dma_addr64(dmanr, sa, da) \
	(*txx927_dma_ops->set_dma_addr64)(dmanr, sa, da)
#define set_txx927_dma_count(dmanr, count) \
	(*txx927_dma_ops->set_dma_count)(dmanr, count)
#define set_txx927_dma_inc(dmanr, sai, dai) \
	(*txx927_dma_ops->set_dma_inc)(dmanr, sai, dai)
#define get_txx927_dma_residue(dmanr) \
	(*txx927_dma_ops->get_dma_residue)(dmanr)
#define get_txx927_dma_status(dmanr) \
	(*txx927_dma_ops->get_dma_status)(dmanr)
#define clear_txx927_dma_status(dmanr) \
	(*txx927_dma_ops->clear_dma_status)(dmanr)
#define get_txx927_dma_irqno(dmanr) \
	(*txx927_dma_ops->get_dma_irqno)(dmanr)
/* for chain operation */
#define set_txx927_dma_chain(dmanr, cha) \
	(*txx927_dma_ops->set_dma_chain)(dmanr, cha)
#define get_txx927_dma_chain(dmanr) \
	(*txx927_dma_ops->get_dma_chain)(dmanr)
#define set_txx927_chdma_mode(desc, mode) \
	(*txx927_dma_ops->set_chdma_mode)(desc, mode)
#define set_txx927_chdma_addr(desc, sa, da) \
	(*txx927_dma_ops->set_chdma_addr)(desc, sa, da)
#define get_txx927_chdma_addr(desc, sa, da) \
	(*txx927_dma_ops->get_chdma_addr)(desc, sa, da)
#define set_txx927_chdma_addr64(desc, sa, da) \
	(*txx927_dma_ops->set_chdma_addr64)(desc, sa, da)
#define get_txx927_chdma_addr64(desc, sa, da) \
	(*txx927_dma_ops->get_chdma_addr64)(desc, sa, da)
#define set_txx927_chdma_count(desc, count) \
	(*txx927_dma_ops->set_chdma_count)(desc, count)
#define get_txx927_chdma_count(desc, count) \
	(*txx927_dma_ops->get_chdma_count)(desc, count)
#define set_txx927_chdma_inc(desc, sai, dai) \
	(*txx927_dma_ops->set_chdma_inc)(desc, sai, dai)
#define set_txx927_chdma_chain(desc, cha) \
	(*txx927_dma_ops->set_chdma_chain)(desc, cha)
#define get_txx927_chdma_chain(desc) \
	(*txx927_dma_ops->get_chdma_chain)(desc)
#define alloc_txx927_chdma_cmd() \
	(*txx927_dma_ops->alloc_chdma_cmd)()
#define free_txx927_chdma_cmd(desc) \
	(*txx927_dma_ops->free_chdma_cmd)(desc)

#endif /* __ASM_TOSHIBA_BOARDS_DMA_H */
