/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#ifndef __ASM_TOSHIBA_BOARDS_PMON_H 
#define __ASM_TOSHIBA_BOARDS_PMON_H 

#ifndef _LANGUAGE_ASSEMBLY
struct pmon_vector {
	int (*read)(int fd, char *buf, int size);
	int (*write)(int fd, char *buf, int size);
	int (*open)(char *name, int mode);
	int (*close)(int fd);
	int (*ioctl)(int fd, int request, void* arg);
	int (*printf)(char *fmstr, ...);
	int (*vsprintf)(char *dst, char *fmtstr, ...);
	int (*ttctl)(int fd, int op, int ap1, int ap2);
	void (*exit)(int status);
	char *(*getenv)(char *name);
	void (*onintr)(int code, long *dat);
	void (*flush_cache)(int cache);
	void (*_exception)(void);
	int (*_fpstatesz)(void);
	void (*_fpinit)(void);
	void *(*_fpstate)(void);
	void (*cop1)(void);
	int (*adr2symoff)(char *dst, int value, int width);
	int (*sym2adr)(long *v, char *label);
	int (*getclkfreq)(void);
	void (*_clkinit)(void);
};

extern struct pmon_vector *pmon_vector;

extern void pmon_printf(char *fmt, ...);
extern void pmon_halt(void);
extern void set_pmon_debug_traps(void);
extern unsigned long toshibaboards_memory_upper;

#endif /* _LANGUAGE_ASSEMBLY */

#define PMON_VECTOR	0xbfc00200
#define PMON_VECTOR_R4K	0xbfc00500 /* with R4KEXCEPTIONS */
#define PMON_VECTOR_TX39	0xbfc00500 /* with TX39_DEBUG_EXCEPTIONS */

#endif /* __ASM_TOSHIBA_BOARDS_PMON_H */
