/*
 * ns87338.h: Configuration Register Description for the
 *            National Semiconductor PC87338/PC97338 (SuperIO).
 *
 *   Based on include/asm-sparc64/ns87303.h.
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 */

#ifndef _ASM_NS87338_H
#define _ASM_NS87338_H 1

/*
 * Controll Register Index Values
 */
#define FER	0x00
#define FAR	0x01
#define PTR	0x02
#define FCR	0x03
#define PCR	0x04
#define PMC	0x06
#define TUP	0x07
#define SID	0x08
#define ASC	0x09
#define CS0LA	0x0a
#define CS0CF	0x0b
#define CS1LA	0x0c
#define CS1CF	0x0d
#define CS0HA	0x10
#define CS1HA	0x11
#define SCF0	0x12
#define SCF1	0x18
#define CLK	0x51

/* Function Enable Register (FER) bits */
#define FER_LPT		0x01
#define FER_SCC1	0x02
#define FER_SCC2	0x04

/* Function Address Register (FAR) bits */
#define FAR_LPT_MASK	0x03
#define FAR_LPTB	0x00
#define FAR_LPTA	0x01
#define FAR_LPTC	0x02
#define FAR_SCC1_MASK	0x0c
#define FAR_SCC1_COM1	0x00
#define FAR_SCC1_COM2	0x04
#define FAR_SCC1_COM3	0x08
#define FAR_SCC1_COM4	0x0c
#define FAR_SCC2_MASK	0x30
#define FAR_SCC2_COM1	0x00
#define FAR_SCC2_COM2	0x10
#define FAR_SCC2_COM3	0x20
#define FAR_SCC2_COM4	0x30

/* Power and Test Register (PTR) bits */
#define PTR_LPTB_IRQ7	0x08
#define PTR_LEVEL_IRQ	0x80	/* When not ECP/EPP: Use level IRQ           */
#define PTR_LPT_REG_DIR	0x80	/* When ECP/EPP: LPT CTR controlls direction */
				/*               of the parallel port	     */

/* Function Control Register (FCR) bits */
#define FCR_ZWS_ENA	0x20	/* Enable short host read/write in ECP/EPP   */

/* Printer Controll Register (PCR) bits */
#define PCR_EPP_ENABLE	0x01
#define PCR_EPP_IEEE	0x02	/* Enable EPP Version 1.9 (IEEE 1284)        */
#define PCR_ECP_ENABLE	0x04
#define PCR_ECP_CLK_ENA	0x08	/* If 0 ECP Clock is stopped on Power down   */
#define PCR_IRQ_POLAR	0x20	/* If 0 IRQ is level high or negative pulse, */
				/* if 1 polarity is inverted                 */
#define PCR_IRQ_ODRAIN	0x40	/* If 1, IRQ is open drain                   */

/* Tape UARTs and Parallel Port Config Register (TUP) bits */
#define TUP_EPP_TIMO	0x04	/* Enable EPP timeout IRQ                    */

/* Advanced SuperIO Config Register (ASC) bits */
#define ASC_LPT_IRQ7	0x01	/* Allways use IRQ7 for LPT                  */

/* Clock Control Register (CLK) bits */
#define CLK_SRC_MASK	0x03
#define CLK_SRC_14MHz	0x00
#define CLK_SRC_24MHz	0x01
#define CLK_SRC_48MHz	0x02
#define CLK_MUL_ENA	0x04

#ifdef __KERNEL__

#include <linux/config.h>
#include <asm/system.h>
#include <asm/io.h>

/* read/write method for Configuration Registers */
static __inline__ void ns87338_writeb(unsigned long port, int index,
				      unsigned char value)
{
	unsigned long flags;

	save_and_cli(flags);
	outb(index, port + 0);
	outb(value, port + 1);
	outb(value, port + 1);
	restore_flags(flags);
}

static __inline__ unsigned char ns87338_readb(unsigned long port, int index)
{
	outb(index, port);
	return inb(port + 1);
}

#endif /* __KERNEL__ */

#endif /* !(_ASM_NS87338_H) */
