/*
 * Copyright (C) 1999, 2000  Tim Waugh <tim@cyberelk.demon.co.uk>
 *
 * This file should only be included by drivers/parport/parport_pc.c.
 * Modified to support TOSHIBA boards. (Sep/2001)
 * Copyright (C) 2001 Toshiba Corporation
 */
#ifndef _ASM_PARPORT_H
#define _ASM_PARPORT_H

#include <linux/config.h>
#if defined(CONFIG_TOSHIBA_BOARDS) || defined(CONFIG_MCT_BOARDS)
extern int mips_parport_base;
extern int mips_parport_irq;
static int __devinit parport_pc_find_nonpci_ports (int autoirq, int autodma)
{
	if (mips_parport_base && mips_parport_irq &&
	    parport_pc_probe_port(mips_parport_base,
				  mips_parport_base + 0x400,
				  mips_parport_irq,
				  PARPORT_DMA_NONE, NULL))
		return 1;
	return 0;
}
#else
static int __devinit parport_pc_find_isa_ports (int autoirq, int autodma);
static int __devinit parport_pc_find_nonpci_ports (int autoirq, int autodma)
{
	return parport_pc_find_isa_ports (autoirq, autodma);
}
#endif

#endif /* _ASM_PARPORT_H */
