#ifndef _ASM_SEMBUF_H
#define _ASM_SEMBUF_H

/* 
 * The semid64_ds structure for the MIPS architecture.
 * Note extra padding because this structure is passed back and forth
 * between kernel and user space.
 *
 * Pad space is left for:
 * - 2 miscellaneous 64-bit values
 */

#ifdef CONFIG_MIPS_RH70_WORKAROUND
/* MIPS RedHat 7.0's bits/ipc.h, bits/sem.h, bits/shm.h are obsolete. */
/* see /usr/include/bit/sem.h in MIPS RedHat 7.0 */
#endif
struct semid64_ds {
	struct ipc64_perm sem_perm;		/* permissions .. see ipc.h */
	__kernel_time_t	sem_otime;		/* last semop time */
#ifdef CONFIG_MIPS_RH70_WORKAROUND
	unsigned long int __unused3;
#endif
	__kernel_time_t	sem_ctime;		/* last change time */
#ifdef CONFIG_MIPS_RH70_WORKAROUND
	unsigned long int __unused4;
#endif
	unsigned long	sem_nsems;		/* no. of semaphores in array */
	unsigned long	__unused1;
	unsigned long	__unused2;
};

#endif /* _ASM_SEMBUF_H */
