/*
 *  linux/include/asm-mips/toshiba-boards/irq.h
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 *
 */
#ifndef __ASM_TOSHIBA_BOARDS_IRQ_H
#define __ASM_TOSHIBA_BOARDS_IRQ_H

#ifndef _LANGUAGE_ASSEMBLY
#include <asm/irq.h>

struct pt_regs;

#ifdef CONFIG_TX_BRANCH_LIKELY_BUG_WORKAROUND
extern void tx_branch_likely_bug_fixup(struct pt_regs *regs);
#endif
#ifdef CONFIG_TX_FPU_C_BUG_WORKAROUND
extern void tx_fpu_c_bug_fixup(struct pt_regs *regs);
#endif

struct resource;
extern int (*toshibaboards_gen_iack)(void);
extern int toshibaboards_i8259_irqroute(int irq);
extern int toshibaboards_i8259_irq_setup(int irq);

extern void mips_cpu_irq_init(u32 irq_base);
extern void tx3927_irq_init(int irq_base);
extern void tx4927_irq_init(int irq_base);
extern void tx4925_irq_init(int irq_base);
extern int tx3927_irq_to_irq(int irq);
extern int tx4927_irq_to_irq(int irq);
extern int tx4925_irq_to_irq(int irq);

extern asmlinkage unsigned int do_IRQ(int irq, struct pt_regs *regs);
extern int (*toshibaboards_irqdispatch)(struct pt_regs *regs);

#endif /* _LANGUAGE_ASSEMBLY */

#define NR_ISA_IRQS 16

#endif /* __ASM_TOSHIBA_BOARDS_IRQ_H */
