/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#ifndef __ASM_TOSHIBA_BOARDS_RBTX4927_H 
#define __ASM_TOSHIBA_BOARDS_RBTX4927_H 

#include <asm/tx4927.h>
#include <asm/addrspace.h>
#include <asm/toshiba-boards/irq.h>

/* CS */
#if 1
/* use PMON's setting */
extern unsigned long rbtx4927_ce_base[8];
#define RBTX4927_CE0	rbtx4927_ce_base[0]
#define RBTX4927_CE1	rbtx4927_ce_base[1]
#define RBTX4927_CE2	rbtx4927_ce_base[2]
#define RBTX4927_CE3	rbtx4927_ce_base[3]
#define RBTX4927_CE4	rbtx4927_ce_base[4]
#define RBTX4927_CE5	rbtx4927_ce_base[5]
#define RBTX4927_CE6	rbtx4927_ce_base[6]
#define RBTX4927_CE7	rbtx4927_ce_base[7]
#else
#define RBTX4927_CE0	0x1f000000	/* 16M */
#define RBTX4927_CE1	0x1e000000	/* 16M */
#define RBTX4927_CE2	0x1c000000	/* 1M */
#define RBTX4927_CE3	0x10000000	/* 64M */
#endif

/* Address map */
#define RBTX4927_FPGA_REG_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00000000)
#define RBTX4927_BOARD_REV_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00000000)
#define RBTX4927_FPGA_REV_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00000002)
#define RBTX4927_LED_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00001000)
#define RBTX4927_DIPSW_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00001002)
#define RBTX4927_IMASK_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00002000)
#define RBTX4927_INTPOL_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00002002)
#define RBTX4927_ISTAT_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00002004)
#define RBTX4927_IMSTAT_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00002006)
#define RBTX4927_SOFTINT_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00003000)
#define RBTX4927_CFGA_STAT_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00004000)
#define RBTX4927_CFGD_STAT_ADDR	(KSEG1 + RBTX4927_CE2 + 0x00004002)
#define RBTX4927_SOFTRESET_ADDR	(KSEG1 + RBTX4927_CE2 + 0x0000f000)
#define RBTX4927_SOFTRESETLOCK_ADDR	(KSEG1 + RBTX4927_CE2 + 0x0000f002)
#define RBTX4927_PCIRESET_ADDR	(KSEG1 + RBTX4927_CE2 + 0x0000f006)
#define RBTX4927_BRAMRTC_BASE	(KSEG1 + RBTX4927_CE2 + 0x00010000)
#define RBTX4927_ETHER_BASE	(KSEG1 + RBTX4927_CE2 + 0x00020000)

/* JMI-TX39IO2 */
#define RBTX4927_IOB_BASE	(KSEG1 + RBTX4927_CE3)

/* Ethernet port address */
#define RBTX4927_ETHER_ADDR	(RBTX4927_ETHER_BASE + 0x280)

/* IEEE1394 board */
#define RBTX4927_JMY1394_BASE	(KSEG1 + RBTX4927_CE5)
#define RBTX4927_PREMIER3_BASE	(RBTX4927_JMY1394_BASE + 0x00100000)

/* bits for ISTAT/IMASK/IMSTAT */
#define RBTX4927_INTB_PCID	0
#define RBTX4927_INTB_PCIC	1
#define RBTX4927_INTB_PCIB	2
#define RBTX4927_INTB_PCIA	3
#define RBTX4927_INTB_DSR	4
#define RBTX4927_INTB_SWI	5
#define RBTX4927_INTF_PCID	(1 << RBTX4927_INTB_PCID)
#define RBTX4927_INTF_PCIC	(1 << RBTX4927_INTB_PCIC)
#define RBTX4927_INTF_PCIB	(1 << RBTX4927_INTB_PCIB)
#define RBTX4927_INTF_PCIA	(1 << RBTX4927_INTB_PCIA)
#define RBTX4927_INTF_DSR	(1 << RBTX4927_INTB_DSR)
#define RBTX4927_INTF_SWI	(1 << RBTX4927_INTB_SWI)

#ifndef _LANGUAGE_ASSEMBLY
#define rbtx4927_board_rev_ptr	\
	((volatile unsigned char *)RBTX4927_BOARD_REV_ADDR)
#define rbtx4927_fpga_rev_ptr	\
	((volatile unsigned char *)RBTX4927_FPGA_REV_ADDR)
#define rbtx4927_led_ptr	\
	((volatile unsigned char *)RBTX4927_LED_ADDR)
#define rbtx4927_dipsw_ptr	\
	((volatile unsigned char *)RBTX4927_DIPSW_ADDR)
#define rbtx4927_imask_ptr	\
	((volatile unsigned char *)RBTX4927_IMASK_ADDR)
#define rbtx4927_intpol_ptr	\
	((volatile unsigned char *)RBTX4927_INTPOL_ADDR)
#define rbtx4927_istat_ptr	\
	((volatile unsigned char *)RBTX4927_ISTAT_ADDR)
#define rbtx4927_imstat_ptr	\
	((volatile unsigned char *)RBTX4927_IMSTAT_ADDR)
#define rbtx4927_softint_ptr	\
	((volatile unsigned char *)RBTX4927_SOFTINT_ADDR)
#define rbtx4927_cfga_ptr	\
	((volatile unsigned char *)RBTX4927_CFGA_ADDR)
#define rbtx4927_cfgd_ptr	\
	((volatile unsigned char *)RBTX4927_CFGD_ADDR)
#define rbtx4927_softreset_ptr	\
	((volatile unsigned char *)RBTX4927_SOFTRESET_ADDR)
#define rbtx4927_softresetlock_ptr	\
	((volatile unsigned char *)RBTX4927_SOFTRESETLOCK_ADDR)
#define rbtx4927_pcireset_ptr	\
	((volatile unsigned char *)RBTX4927_PCIRESET_ADDR)
#define rbtx4927_bramrtc_ptr	\
	((volatile unsigned char *)RBTX4927_BRAMRTC_BASE)

#define rbtx4927_led_on(n)	(*rbtx4927_led_ptr |= 1<<(n))
#define rbtx4927_led_off(n)	(*rbtx4927_led_ptr = *rbtx4927_led_ptr &~ (1<<(n)))
#define rbtx4927_led_toggle(n)	(*rbtx4927_led_ptr = *rbtx4927_led_ptr ^(1<<(n)))

/* clock */
extern int rbtx4927_master_clock;
extern int rbtx4927_gbus_clock;
#define RBTX4927_GBUSCLK	rbtx4927_gbus_clock
#define RBTX4927_IMCLK		(RBTX4927_GBUSCLK / 2)

#endif /* _LANGUAGE_ASSEMBLY */


/*
 * IRQ mappings
 */

#define RBTX4927_SOFT_INT0	0	/* not used */
#define RBTX4927_SOFT_INT1	1	/* not used */
#define RBTX4927_IRC_INT	2
#define RBTX4927_TIMER_INT	7

/* These are the virtual IRQ numbers, we divide all IRQ's into
 * 'spaces', the 'space' determines where and how to enable/disable
 * that particular IRQ on an RBTX4927 machine.  Add new 'spaces' as new
 * IRQ hardware is supported.
 */
#define RBTX4927_NR_IRQ_LOCAL	8
#define RBTX4927_NR_IRQ_IRC	32	/* On-Chip IRC */
#define RBTX4927_NR_IRQ_IOC	8	/* IOC */
#define RBTX4927_NR_IRQ_ISAC	8	/* JMI-TX39IO2 ISA */

#define RBTX4927_IRQ_LOCAL	NR_ISA_IRQS
#define RBTX4927_IRQ_IRC	(RBTX4927_IRQ_LOCAL + RBTX4927_NR_IRQ_LOCAL)
#define RBTX4927_IRQ_IOC	(RBTX4927_IRQ_IRC + RBTX4927_NR_IRQ_IRC)
#define RBTX4927_IRQ_ISAC	(RBTX4927_IRQ_IOC + RBTX4927_NR_IRQ_IOC)
#define RBTX4927_IRQ_END	RBTX4927_IRQ_ISAC

#define RBTX4927_IRQ_LOCAL_SOFT0	(RBTX4927_IRQ_LOCAL + RBTX4927_SOFT_INT0)
#define RBTX4927_IRQ_LOCAL_SOFT1	(RBTX4927_IRQ_LOCAL + RBTX4927_SOFT_INT0)
#define RBTX4927_IRQ_LOCAL_IRC	(RBTX4927_IRQ_LOCAL + RBTX4927_IRC_INT)
#define RBTX4927_IRQ_LOCAL_TIMER	(RBTX4927_IRQ_LOCAL + RBTX4927_TIMER_INT)
#define RBTX4927_IRQ_IRC_ECCERR	(RBTX4927_IRQ_IRC + TX4927_IR_ECCERR)
#define RBTX4927_IRQ_IRC_WTOERR	(RBTX4927_IRQ_IRC + TX4927_IR_WTOERR)
#define RBTX4927_IRQ_IRC_INT(n)	(RBTX4927_IRQ_IRC + TX4927_IR_INT(n))
#define RBTX4927_IRQ_IRC_SIO(n)	(RBTX4927_IRQ_IRC + TX4927_IR_SIO(n))
#define RBTX4927_IRQ_IRC_DMA(n)	(RBTX4927_IRQ_IRC + TX4927_IR_DMA(n))
#define RBTX4927_IRQ_IRC_PIO	(RBTX4927_IRQ_IRC + TX4927_IR_PIO)
#define RBTX4927_IRQ_IRC_PDMAC	(RBTX4927_IRQ_IRC + TX4927_IR_PDMAC)
#define RBTX4927_IRQ_IRC_PCIC	(RBTX4927_IRQ_IRC + TX4927_IR_PCIC)
#define RBTX4927_IRQ_IRC_TMR(n)	(RBTX4927_IRQ_IRC + TX4927_IR_TMR(n))
#define RBTX4927_IRQ_IRC_PCIERR	(RBTX4927_IRQ_IRC + TX4927_IR_PCIERR)
#define RBTX4927_IRQ_IRC_PCIPMA	(RBTX4927_IRQ_IRC + TX4927_IR_PCIPMA)
#define RBTX4927_IRQ_IRC_ACLC	(RBTX4927_IRQ_IRC + TX4927_IR_ACLC)
#define RBTX4927_IRQ_IRC_ACKCPMA	(RBTX4927_IRQ_IRC + TX4927_IR_ACKCPMA)
#define RBTX4927_IRQ_IOC_PCID	(RBTX4927_IRQ_IOC + RBTX4927_INTB_PCID)
#define RBTX4927_IRQ_IOC_PCIC	(RBTX4927_IRQ_IOC + RBTX4927_INTB_PCIC)
#define RBTX4927_IRQ_IOC_PCIB	(RBTX4927_IRQ_IOC + RBTX4927_INTB_PCIB)
#define RBTX4927_IRQ_IOC_PCIA	(RBTX4927_IRQ_IOC + RBTX4927_INTB_PCIA)
#define RBTX4927_IRQ_IOC_DSR	(RBTX4927_IRQ_IOC + RBTX4927_INTB_DSR)
#define RBTX4927_IRQ_IOC_SWI	(RBTX4927_IRQ_IOC + RBTX4927_INTB_SWI)

/* Modem (Do not use this. Set W28 to OPEN and use RBTX4927_IRQ_IOC_DSR */
/* #define RBTX4927_IRQ_MODEM	RBTX4927_IRQ_IRC_INT(0) */
/* IOC (PCI, etc) */
#define RBTX4927_IRQ_IOCINT	RBTX4927_IRQ_IRC_INT(1)
/* Onboard 10M Ether */
#define RBTX4927_IRQ_ETHER	RBTX4927_IRQ_IRC_INT(3)

/* IEEE1394 (Note that this may conflicts with JMI-TX39IO2 10M Ether...) */
#define RBTX4927_IRQ_PREMIER3	RBTX4927_IRQ_IRC_INT(0)

#endif /* __ASM_TOSHIBA_BOARDS_RBTX4927_H */
