/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 */
#ifndef __ASM_TOSHIBA_BOARDS_TSDB_H 
#define __ASM_TOSHIBA_BOARDS_TSDB_H 

#include <asm/v320usc.h>
#include <asm/addrspace.h>
#include <asm/toshiba-boards/irq.h>

/* LocalBus/PCI address */
#if 1
/*
 * These definitions are differ from "SDB Hardware Specification" because:
 *	1. MIPS/Linux is hard to use high(>=0x20000000) physaddr.
 *	2. Many codes assume that 'bus(PCI) address' == 'physical address'.
 */
/* SDRAM Aperture */
#define	TSDB_LB_SDRAM_APERTURE	0x00000000
#define	TSDB_PCI_SDRAM_APERTURE	TSDB_LB_SDRAM_APERTURE
#define	TSDB_SDRAM_APERTURE_ADBITS	4	/* 256M(AD[31:28]) */
/* ROM Aperture */
#define	TSDB_LB_ROM_APERTURE	0x1c000000
#define	TSDB_PCI_ROM_APERTURE	0x00000000	/* NOT USED */
#define	TSDB_ROM_APERTURE_ADBITS	6	/* 64M(AD[31:26]) */
/* PCU Aperture LB/PCI address */
#define	TSDB_LB_PCU_APERTURE	0x10000000
#define	TSDB_PCI_PCU_APERTURE	0x00000000	/* NOT USED */
#define	TSDB_PCU_APERTURE_ADBITS	5	/* 128M(AD[31:27]) */
/* USC REG Aperture (64K) */
#define	TSDB_LB_USCREG_APERTURE	0x18000000
#define	TSDB_PCI_USCREG_APERTURE	TSDB_LB_USCREG_APERTURE
/* PCI Aperture  */
#define	TSDB_LB_PCI_APERTURE_0	0x19000000
#define	TSDB_PCI_PCI_APERTURE_0	0x00000000
#define	TSDB_PCI_APERTURE_0_ADBITS	8	/* 16M(AD[31:24]) */
#define	TSDB_LB_PCI_APERTURE_1	0x08000000
#define	TSDB_PCI_PCI_APERTURE_1	TSDB_LB_PCI_APERTURE_1
#define	TSDB_PCI_APERTURE_1_ADBITS	5	/* 128M(AD[31:27]) */

#else	/* definitions in SDB Hardware Specification */

/* SDRAM Aperture */
#define	TSDB_LB_SDRAM_APERTURE	0x00000000
#define	TSDB_PCI_SDRAM_APERTURE	0x10000000
#define	TSDB_SDRAM_APERTURE_ADBITS	4	/* 256M(AD[31:28]) */
/* ROM Aperture */
#define	TSDB_LB_ROM_APERTURE	0x1c000000
#define	TSDB_PCI_ROM_APERTURE	0x00000000	/* NOT USED */
#define	TSDB_ROM_APERTURE_ADBITS	6	/* 64M(AD[31:26]) */
/* PCU Aperture */
#define	TSDB_LB_PCU_APERTURE	0x10000000
#define	TSDB_PCI_PCU_APERTURE	0x00000000	/* NOT USED */
#define	TSDB_PCU_APERTURE_ADBITS	5	/* 128M(AD[31:27]) */
/* USC REG Aperture (64K) */
#define	TSDB_LB_USCREG_APERTURE	0x18000000
#define	TSDB_PCI_USCREG_APERTURE	0x02000000
/* PCI Aperture */
#define	TSDB_LB_PCI_APERTURE_0	0x1a000000
#define	TSDB_PCI_PCI_APERTURE_0	0x00000000
#define	TSDB_PCI_APERTURE_0_ADBITS	7	/* 32M(AD[31:25]) */
#define	TSDB_LB_PCI_APERTURE_1	0x40000000
#define	TSDB_PCI_PCI_APERTURE_1	0x40000000
#define	TSDB_PCI_APERTURE_1_ADBITS	3	/* 512M(AD[31:29) */

#endif

/* Address map */
#define TSDB_SUPERIO_BASE	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x04000000)
#define TSDB_BRAMRTC_BASE	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05000000)
#define TSDB_DIPSW1_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05100000)
#define TSDB_DIPSW2_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05100010)
#define TSDB_LED_ADDR		(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05100020)
#define TSDB_FLASHWP_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05100030)
#define TSDB_LEDDISP_BASE	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05200000)
#define TSDB_PCI_ISTAT_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05300000)
#define TSDB_IOC_ISTAT_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05300010)
#define TSDB_NMI_ISTAT_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05300020)
#define TSDB_PCI_IMASK_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05300030)
#define TSDB_IOC_IMASK_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05300040)
#define TSDB_SOFTRESET_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05400000)
#define TSDB_PCIRESET_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05500000)
#define TSDB_SOFTINT_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05600000)
#define TSDB_FPGA_REV_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05700000)
#define TSDB_BOARD_REV_ADDR	(KSEG1 + TSDB_LB_PCU_APERTURE + 0x05700010)
#define TSDB_ETHER_BASE		(KSEG1 + TSDB_LB_PCU_APERTURE + 0x06000000)
#define TSDB_USC_BASE		(KSEG1 + TSDB_LB_USCREG_APERTURE)

/* SuperIO Configuration Register */
#define TSDB_SUPERIO_CONFIG	(TSDB_SUPERIO_BASE + 0x398)
/* SuperIO SCC base address */
#define TSDB_UART0_BASE	(TSDB_SUPERIO_BASE + 0x3f8)
#define TSDB_UART1_BASE	(TSDB_SUPERIO_BASE + 0x2f8)
#if 1
#define TSDB_BASE_BAUD	(24000000 / 13 / 16)	/* 24MHz, prescaler:13 */
#else
#define TSDB_BASE_BAUD	(14318180 / 13 / 16)	/* 14.318MHz, prescaler:13 */
#endif
/* SuperIO Parallel port address (LPTB) */
#define TSDB_LPT_ADDR	(TSDB_SUPERIO_BASE + 0x378)

/* Ethernet port address */
#define TSDB_ETHER_ADDR	(TSDB_ETHER_BASE + 0x300)


/* bits for DIPSW1 */
#define	TSDB_DIPSW1_APL5	0x80
#define	TSDB_DIPSW1_APL4	0x40
#define	TSDB_DIPSW1_APL3	0x20
#define	TSDB_DIPSW1_APL2	0x10
#define	TSDB_DIPSW1_APL1	0x08
#define	TSDB_DIPSW1_FLASH_WP	0x04	/* System Flash Write Protect */
#define	TSDB_DIPSW1_COMM	0x02	/* Debug Comm: Serial/Ether */
#define	TSDB_DIPSW1_BOOTROM	0x01	/* Boot from Boot PROM */

/* bits for DIPSW2 */
#define	TSDB_DIPSW2_BUSE	0x80	/* Board Usage: CPCI/StandAlone */
#define	TSDB_DIPSW2_CLOCK_4	0x00	/* 1:4 (reserved at TX43) */
#define	TSDB_DIPSW2_CLOCK_2_5	0x20	/* 1:2.5 (1:1.5 at TX43) */
#define	TSDB_DIPSW2_CLOCK_2	0x40	/* 1:2 */
#define	TSDB_DIPSW2_CLOCK_3	0x60	/* 1:3 */
#define	TSDB_DIPSW2_CLOCK_MASK	0x60	/* MaskterClock:SystemClock */
#define	TSDB_DIPSW2_BIGENDIAN	0x10
#define	TSDB_DIPSW2_BPROM_AC	0x08	/* Boot PROM can be accessed */
#define	TSDB_DIPSW2_EPROMBOOT	0x04	/* Boot from ROM Emulator */
#define	TSDB_DIPSW2_EXTROM_AC	0x02	/* Ext. ROM Can be accessed */
#define	TSDB_DIPSW2_SYSIF_R43	0x01	/* Syscmd type: 43mode/49mode */

/* bits for PCI_ISTAT/PCI_IMASK */
#define TSDB_INTB_PCI_SERR	0
#define TSDB_INTB_PCI_PERR	1
#define TSDB_INTB_PCI_INTD	2
#define TSDB_INTB_PCI_INTC	3
#define TSDB_INTB_PCI_INTB	4
#define TSDB_INTB_PCI_INTA	5
#define TSDB_INTB_PCI_ENUM	6
#define TSDB_INTF_PCI_INTA	(1 << TSDB_INTB_PCI_INTA)
#define TSDB_INTF_PCI_INTB	(1 << TSDB_INTB_PCI_INTB)
#define TSDB_INTF_PCI_INTC	(1 << TSDB_INTB_PCI_INTC)
#define TSDB_INTF_PCI_INTD	(1 << TSDB_INTB_PCI_INTD)
#define TSDB_INTF_PCI_PERR	(1 << TSDB_INTB_PCI_PERR)
#define TSDB_INTF_PCI_SERR	(1 << TSDB_INTB_PCI_SERR)
#define TSDB_INTF_PCI_ENUM	(1 << TSDB_INTB_PCI_ENUM)

/* bits for IOC_ISTAT/IOC_IMASK */
#define TSDB_INTB_IOC_SOFTINT	0
#define TSDB_INTB_IOC_PUSHSW	1	/* Int. SW */
#define TSDB_INTB_IOC_PAR	2	/* Parallel Port */
#define TSDB_INTB_IOC_UART0	3	/* Debug UART */
#define TSDB_INTB_IOC_UART1	4	/* User UART */
#define TSDB_INTB_IOC_UART(ch)	(3 + (ch))
#define TSDB_INTB_IOC_RTC	5
#define TSDB_INTF_IOC_SOFTINT	(1 << TSDB_INTB_IOC_SOFTINT)
#define TSDB_INTF_IOC_PUSHSW	(1 << TSDB_INTB_IOC_PUSHSW)
#define TSDB_INTF_IOC_PAR	(1 << TSDB_INTB_IOC_PAR)
#define TSDB_INTF_IOC_UART1	(1 << TSDB_INTB_IOC_UART1)
#define TSDB_INTF_IOC_UART0	(1 << TSDB_INTB_IOC_UART0)
#define TSDB_INTF_IOC_UART(ch)	(1 << TSDB_INTB_IOC_UART(ch))
#define TSDB_INTF_IOC_RTC	(1 << TSDB_INTB_IOC_RTC)

/* bits for NMI_ISTAT */
#define TSDB_INTB_NMI_DEG	1
#define TSDB_INTB_NMI_NMI	2
#define TSDB_INTF_NMI_DEG	(1 << TSDB_INTB_NMI_DEG)
#define TSDB_INTF_NMI_NMI	(1 << TSDB_INTB_NMI_NMI)

#ifndef _LANGUAGE_ASSEMBLY
#define tsdb_bramrtc_ptr	((volatile unsigned char *)TSDB_BRAMRTC_BASE)
#define tsdb_dipsw1_ptr		((volatile unsigned char *)TSDB_DIPSW1_ADDR)
#define tsdb_dipsw2_ptr		((volatile unsigned char *)TSDB_DIPSW2_ADDR)
#define tsdb_led_ptr		((volatile unsigned char *)TSDB_LED_ADDR)
#define tsdb_flashwp_ptr	((volatile unsigned char *)TSDB_FLASHWP_ADDR)
#define tsdb_leddisp_ptr	((volatile unsigned char *)TSDB_LEDDISP_BASE)
#define tsdb_pci_istat_ptr	((volatile unsigned char *)TSDB_PCI_ISTAT_ADDR)
#define tsdb_ioc_istat_ptr	((volatile unsigned char *)TSDB_IOC_ISTAT_ADDR)
#define tsdb_nmi_istat_ptr	((volatile unsigned char *)TSDB_NMI_ISTAT_ADDR)
#define tsdb_pci_imask_ptr	((volatile unsigned char *)TSDB_PCI_IMASK_ADDR)
#define tsdb_ioc_imask_ptr	((volatile unsigned char *)TSDB_IOC_IMASK_ADDR)
#define tsdb_softreset_ptr	((volatile unsigned char *)TSDB_SOFTRESET_ADDR)
#define tsdb_pcireset_ptr	((volatile unsigned char *)TSDB_PCIRESET_ADDR)
#define tsdb_softint_ptr	((volatile unsigned char *)TSDB_SOFTINT_ADDR)
#define tsdb_fpga_rev_ptr	((volatile unsigned char *)TSDB_FPGA_REV_ADDR)
#define tsdb_board_rev_ptr	((volatile unsigned char *)TSDB_BOARD_REV_ADDR)

#define tsdb_old_rtc()	(*tsdb_fpga_rev_ptr < 9)

#define tsdb_led_on(n)		(*tsdb_led_ptr |= 1<<(n))
#define tsdb_led_off(n)		(*tsdb_led_ptr = *tsdb_led_ptr &~ (1<<(n)))
#define tsdb_led_toggle(n)	(*tsdb_led_ptr = *tsdb_led_ptr ^(1<<(n)))
#define tsdb_leddisp_addr(addr)	(tsdb_leddisp_ptr+((addr)<<2))
#define tsdb_leddisp_putc(n, c)	(*tsdb_leddisp_addr(0x38|((n)&7)) = (c))
extern void tsdb_leddisp_puts(const char *s);
extern void tsdb_leddisp_put(unsigned long val);
#endif /* _LANGUAGE_ASSEMBLY */


/*
 * MIPS-IRQ mappings
 *
 *	USC0	MIPS-IP2(INT0)	USC Internal Interrupt
 *	USC1	MIPS-IP3(INT1)	PCI Bus Interrupt, ENUM
 *	ETHER	MIPS-IP5(INT3)	OnBoard Ether
 *	IOC	MIPS-IP6(INT4)	UART, Parallel, PushSwitch
 */
#define TSDB_SOFT_INT0	0	/* not used */
#define TSDB_SOFT_INT1	1	/* not used */
#define TSDB_USC_INT	2
#define TSDB_PCI_INT	3
#define TSDB_STACK_INT0	4
#define TSDB_STACK_INT1	5
#define TSDB_ETHER_INT	5
#define TSDB_IOC_INT	6
#define TSDB_TIMER_INT	7


/* These are the virtual IRQ numbers, we divide all IRQ's into
 * 'spaces', the 'space' determines where and how to enable/disable
 * that particular IRQ on an TSDB machine.  Add new 'spaces' as new
 * IRQ hardware is supported.
 */
#define TSDB_NR_IRQ_LOCAL	8
#define TSDB_NR_IRQ_PCI		8
#define TSDB_NR_IRQ_IOC		16
#define TSDB_NR_IRQ_USC		32

#define TSDB_IRQ_LOCAL	NR_ISA_IRQS
#define TSDB_IRQ_PCI	(TSDB_IRQ_LOCAL + TSDB_NR_IRQ_LOCAL)
#define TSDB_IRQ_IOC	(TSDB_IRQ_PCI + TSDB_NR_IRQ_PCI)
#define TSDB_IRQ_USC	(TSDB_IRQ_IOC + TSDB_NR_IRQ_IOC)
#define TSDB_IRQ_END	(TSDB_IRQ_USC + TSDB_NR_IRQ_USC)
#define TSDB_IRQ_IS_LOCAL(irq)	(TSDB_IRQ_LOCAL <= (irq) && (irq) < TSDB_IRQ_PCI)
#define TSDB_IRQ_IS_PCI(irq)	(TSDB_IRQ_PCI <= (irq) && (irq) < TSDB_IRQ_IOC)
#define TSDB_IRQ_IS_IOC(irq)	(TSDB_IRQ_IOC <= (irq) && (irq) < TSDB_IRQ_USC)
#define TSDB_IRQ_IS_USC(irq)	(TSDB_IRQ_USC <= (irq) && (irq) < TSDB_IRQ_END)

#define TSDB_IRQ_LOCAL_SOFT0	(TSDB_IRQ_LOCAL + TSDB_SOFT_INT0)
#define TSDB_IRQ_LOCAL_SOFT1	(TSDB_IRQ_LOCAL + TSDB_SOFT_INT0)
#define TSDB_IRQ_LOCAL_USC	(TSDB_IRQ_LOCAL + TSDB_USC_INT)
#define TSDB_IRQ_LOCAL_PCI	(TSDB_IRQ_LOCAL + TSDB_PCI_INT)
#define TSDB_IRQ_LOCAL_STACK0	(TSDB_IRQ_LOCAL + TSDB_STACK_INT0)
#define TSDB_IRQ_LOCAL_STACK1	(TSDB_IRQ_LOCAL + TSDB_STACK_INT1)
#define TSDB_IRQ_LOCAL_ETHER	(TSDB_IRQ_LOCAL + TSDB_ETHER_INT)
#define TSDB_IRQ_LOCAL_IOC	(TSDB_IRQ_LOCAL + TSDB_IOC_INT)
#define TSDB_IRQ_LOCAL_TIMER	(TSDB_IRQ_LOCAL + TSDB_TIMER_INT)
#define TSDB_IRQ_PCI_INTA	(TSDB_IRQ_PCI + TSDB_INTB_PCI_INTA)
#define TSDB_IRQ_PCI_INTB	(TSDB_IRQ_PCI + TSDB_INTB_PCI_INTB)
#define TSDB_IRQ_PCI_INTC	(TSDB_IRQ_PCI + TSDB_INTB_PCI_INTC)
#define TSDB_IRQ_PCI_INTD	(TSDB_IRQ_PCI + TSDB_INTB_PCI_INTD)
#define TSDB_IRQ_PCI_PERR	(TSDB_IRQ_PCI + TSDB_INTB_PCI_PERR)
#define TSDB_IRQ_PCI_SERR	(TSDB_IRQ_PCI + TSDB_INTB_PCI_SERR)
#define TSDB_IRQ_PCI_ENUM	(TSDB_IRQ_PCI + TSDB_INTB_PCI_ENUM)
#define TSDB_IRQ_IOC_SOFTINT	(TSDB_IRQ_IOC + TSDB_INTB_IOC_SOFTINT)
#define TSDB_IRQ_IOC_PUSHSW	(TSDB_IRQ_IOC + TSDB_INTB_IOC_PUSHSW)
#define TSDB_IRQ_IOC_PAR	(TSDB_IRQ_IOC + TSDB_INTB_IOC_PAR)
#define TSDB_IRQ_IOC_UART0	(TSDB_IRQ_IOC + TSDB_INTB_IOC_UART0)
#define TSDB_IRQ_IOC_UART1	(TSDB_IRQ_IOC + TSDB_INTB_IOC_UART1)
#define TSDB_IRQ_IOC_UART(ch)	(TSDB_IRQ_IOC + TSDB_INTB_IOC_UART(ch))
#define TSDB_IRQ_USC_TIMER0	(TSDB_IRQ_USC + USC_INTB_TIMER0)
#define TSDB_IRQ_USC_TIMER1	(TSDB_IRQ_USC + USC_INTB_TIMER1)
#define TSDB_IRQ_USC_DMA0	(TSDB_IRQ_USC + USC_INTB_DMA0)
#define TSDB_IRQ_USC_DMA1	(TSDB_IRQ_USC + USC_INTB_DMA1)
#define TSDB_IRQ_USC_HBI	(TSDB_IRQ_USC + USC_INTB_HBI)
#define TSDB_IRQ_USC_WDI	(TSDB_IRQ_USC + USC_INTB_WDI)
#define TSDB_IRQ_USC_BWI	(TSDB_IRQ_USC + USC_INTB_BWI)
#define TSDB_IRQ_USC_PSLAVE_PI	(TSDB_IRQ_USC + USC_INTB_PSLAVE_PI)
#define TSDB_IRQ_USC_PMASTER_PI	(TSDB_IRQ_USC + USC_INTB_PMASTER_PI)
#define TSDB_IRQ_USC_PCI_T_ABORT	(TSDB_IRQ_USC + USC_INTB_PCI_T_ABORT)
#define TSDB_IRQ_USC_PCI_M_ABORT	(TSDB_IRQ_USC + USC_INTB_PCI_M_ABORT)
#define TSDB_IRQ_USC_DRAM_PI	(TSDB_IRQ_USC + USC_INTB_DRAM_PI)

#endif /* __ASM_TOSHIBA_BOARDS_TSDB_H */
