/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#ifndef __ASM_MIPS_TX4927_H 
#define __ASM_MIPS_TX4927_H 

#include <asm/txx927.h>

#define TX4927_REG_BASE	0xff1f0000
#define TX4927_REG_SIZE	0x00010000

#define TX4927_SDRAMC_REG	(TX4927_REG_BASE + 0x8000)
#define TX4927_EBUSC_REG	(TX4927_REG_BASE + 0x9000)
#define TX4927_DMA_REG		(TX4927_REG_BASE + 0xb000)
#define TX4927_IRC_REG		(TX4927_REG_BASE + 0xf600)
#define TX4927_PCIC_REG		(TX4927_REG_BASE + 0xd000)
#define TX4927_CCFG_REG		(TX4927_REG_BASE + 0xe000)
#define TX4927_NR_TMR	3
#define TX4927_TMR_REG(ch)	((TX4927_REG_BASE + 0xf000) + (ch) * 0x100)
#define TX4927_NR_SIO	2
#define TX4927_SIO_REG(ch)	((TX4927_REG_BASE + 0xf300) + (ch) * 0x100)
#define TX4927_PIO_REG		(TX4927_REG_BASE + 0xf500)
#define TX4927_ACLC_REG		(TX4927_REG_BASE + 0xf700)

#ifdef _LANGUAGE_ASSEMBLY
#define _CONST64(c)	c
#else
#define _CONST64(c)	c##ull

#include <asm/byteorder.h>

#ifdef __BIG_ENDIAN
#define endian_def_l2(e1,e2)	\
	volatile unsigned long e1,e2
#define endian_def_s2(e1,e2)	\
	volatile unsigned short e1,e2
#define endian_def_sb2(e1,e2,e3)	\
	volatile unsigned short e1;volatile unsigned char e2,e3
#define endian_def_b2s(e1,e2,e3)	\
	volatile unsigned char e1,e2;volatile unsigned short e3
#define endian_def_b4(e1,e2,e3,e4)	\
	volatile unsigned char e1,e2,e3,e4
#else
#define endian_def_l2(e1,e2)	\
	volatile unsigned long e2,e1
#define endian_def_s2(e1,e2)	\
	volatile unsigned short e2,e1
#define endian_def_sb2(e1,e2,e3)	\
	volatile unsigned char e3,e2;volatile unsigned short e1
#define endian_def_b2s(e1,e2,e3)	\
	volatile unsigned short e3;volatile unsigned char e2,e1
#define endian_def_b4(e1,e2,e3,e4)	\
	volatile unsigned char e4,e3,e2,e1
#endif

struct tx4927_sdramc_reg {
	volatile unsigned long long cr[4];
	volatile unsigned long long unused0[4];
	volatile unsigned long long tr;
	volatile unsigned long long unused1[2];
	volatile unsigned long long cmd;
};

struct tx4927_ebusc_reg {
	volatile unsigned long long cr[8];
};

struct tx4927_dma_reg {
	struct tx4927_dma_ch_reg {
		volatile unsigned long long cha;
		volatile unsigned long long sar;
		volatile unsigned long long dar;
		endian_def_l2(unused0, cntr);
		endian_def_l2(unused1, sair);
		endian_def_l2(unused2, dair);
		endian_def_l2(unused3, ccr);
		endian_def_l2(unused4, csr);
	} ch[4];
	volatile unsigned long long dbr[8];
	volatile unsigned long long tdhr;
	volatile unsigned long long midr;
	endian_def_l2(unused0, mcr);
};

struct tx4927_irc_reg {
	volatile unsigned long cer;
	volatile unsigned long cr[2];
	volatile unsigned long unused0;
	volatile unsigned long ilr[8];
	volatile unsigned long unused1[4];
	volatile unsigned long imr;
	volatile unsigned long unused2[7];
	volatile unsigned long scr;
	volatile unsigned long unused3[7];
	volatile unsigned long ssr;
	volatile unsigned long unused4[7];
	volatile unsigned long csr;
};

struct tx4927_pcic_reg {
	volatile unsigned long pciid;
	volatile unsigned long pcistatus;
	volatile unsigned long pciccrev;
	volatile unsigned long pcicfg1;
	volatile unsigned long p2gm0plbase;		/* +10 */
	volatile unsigned long p2gm0pubase;
	volatile unsigned long p2gm1plbase;
	volatile unsigned long p2gm1pubase;
	volatile unsigned long p2gm2pbase;		/* +20 */
	volatile unsigned long p2giopbase;
	volatile unsigned long unused0;
	volatile unsigned long pcisid;
	volatile unsigned long unused1;		/* +30 */
	volatile unsigned long pcicapptr;
	volatile unsigned long unused2;
	volatile unsigned long pcicfg2;
	volatile unsigned long g2ptocnt;		/* +40 */
	volatile unsigned long unused3[15];
	volatile unsigned long g2pstatus;		/* +80 */
	volatile unsigned long g2pmask;
	volatile unsigned long pcisstatus;
	volatile unsigned long pcimask;
	volatile unsigned long p2gcfg;		/* +90 */
	volatile unsigned long p2gstatus;
	volatile unsigned long p2gmask;
	volatile unsigned long p2gccmd;
	volatile unsigned long unused4[24];		/* +a0 */
	volatile unsigned long pbareqport;		/* +100 */
	volatile unsigned long pbacfg;
	volatile unsigned long pbastatus;
	volatile unsigned long pbamask;
	volatile unsigned long pbabm;		/* +110 */
	volatile unsigned long pbacreq;
	volatile unsigned long pbacgnt;
	volatile unsigned long pbacstate;
	volatile unsigned long long g2pmgbase[3];		/* +120 */
	volatile unsigned long long g2piogbase;
	volatile unsigned long g2pmmask[3];		/* +140 */
	volatile unsigned long g2piomask;
	volatile unsigned long long g2pmpbase[3];		/* +150 */
	volatile unsigned long long g2piopbase;
	volatile unsigned long pciccfg;		/* +170 */
	volatile unsigned long pcicstatus;
	volatile unsigned long pcicmask;
	volatile unsigned long unused5;
	volatile unsigned long long p2gmgbase[3];		/* +180 */
	volatile unsigned long long p2giogbase;
	volatile unsigned long g2pcfgadrs;		/* +1a0 */
	volatile unsigned long g2pcfgdata;
	volatile unsigned long unused6[8];
	volatile unsigned long g2pintack;
	volatile unsigned long g2pspc;
	volatile unsigned long unused7[12];		/* +1d0 */
	volatile unsigned long long pdmca;		/* +200 */
	volatile unsigned long long pdmga;
	volatile unsigned long long pdmpa;
	volatile unsigned long long pdmcut;
	volatile unsigned long long pdmcnt;		/* +220 */
	volatile unsigned long long pdmsts;
	volatile unsigned long long unused8[2];
	volatile unsigned long long pdmdb[4];		/* +240 */
	volatile unsigned long long pdmtdh;		/* +260 */
	volatile unsigned long long pdmdms;
};

struct tx4927_ccfg_reg {
	volatile unsigned long long ccfg;
	volatile unsigned long long crir;
	volatile unsigned long long pcfg;
	volatile unsigned long long tear;
	volatile unsigned long long clkctr;
	volatile unsigned long long unused0;
	volatile unsigned long long garbc;
	volatile unsigned long long unused1;
	volatile unsigned long long unused2;
	volatile unsigned long long ramp;
};

struct tx4927_aclc_reg {
	volatile unsigned long acctlen;
	volatile unsigned long acctldis;
	volatile unsigned long acregacc;
	volatile unsigned long unused0;
	volatile unsigned long acintsts;
	volatile unsigned long acintmsts;
	volatile unsigned long acinten;
	volatile unsigned long acintdis;
	volatile unsigned long acsemaph;
	volatile unsigned long unused1[7];
	volatile unsigned long acgpidat;
	volatile unsigned long acgpodat;
	volatile unsigned long acslten;
	volatile unsigned long acsltdis;
	volatile unsigned long acfifosts;
	volatile unsigned long unused2[11];
	volatile unsigned long acdmasts;
	volatile unsigned long acdmasel;
	volatile unsigned long unused3[6];
	volatile unsigned long acaudodat;
	volatile unsigned long acsurrdat;
	volatile unsigned long accentdat;
	volatile unsigned long aclfedat;
	volatile unsigned long acaudiat;
	volatile unsigned long unused4;
	volatile unsigned long acmodoat;
	volatile unsigned long acmodidat;
	volatile unsigned long unused5[15];
	volatile unsigned long acrevid;
};

#undef endian_def_l2
#undef endian_def_s2(e1,e2)
#undef endian_def_sb2(e1,e2,e3)
#undef endian_def_b2s(e1,e2,e3)
#undef endian_def_b4(e1,e2,e3,e4)

#endif /* _LANGUAGE_ASSEMBLY */

/*
 * SDRAMC
 */

/*
 * EBUSC
 */

/*
 * DMA
 */
/* bits for MCR */
#define TX4927_DMA_MCR_EIS(ch)	(0x10000000<<(ch))
#define TX4927_DMA_MCR_DIS(ch)	(0x01000000<<(ch))
#define TX4927_DMA_MCR_RSFIF	0x00000080
#define TX4927_DMA_MCR_FIFUM(ch)	(0x00000008<<(ch))
#define TX4927_DMA_MCR_RPRT	0x00000002
#define TX4927_DMA_MCR_MSTEN	0x00000001

/* bits for CCRn */
#define TX4927_DMA_CCR_IMMCHN	0x20000000
#define TX4927_DMA_CCR_USEXFSZ	0x10000000
#define TX4927_DMA_CCR_LE	0x08000000
#define TX4927_DMA_CCR_DBINH	0x04000000
#define TX4927_DMA_CCR_SBINH	0x02000000
#define TX4927_DMA_CCR_CHRST	0x01000000
#define TX4927_DMA_CCR_RVBYTE	0x00800000
#define TX4927_DMA_CCR_ACKPOL	0x00400000
#define TX4927_DMA_CCR_REQPL	0x00200000
#define TX4927_DMA_CCR_EGREQ	0x00100000
#define TX4927_DMA_CCR_CHDN	0x00080000
#define TX4927_DMA_CCR_DNCTL	0x00060000
#define TX4927_DMA_CCR_EXTRQ	0x00010000
#define TX4927_DMA_CCR_INTRQD	0x0000e000
#define TX4927_DMA_CCR_INTENE	0x00001000
#define TX4927_DMA_CCR_INTENC	0x00000800
#define TX4927_DMA_CCR_INTENT	0x00000400
#define TX4927_DMA_CCR_CHNEN	0x00000200
#define TX4927_DMA_CCR_XFACT	0x00000100
#define TX4927_DMA_CCR_SMPCHN	0x00000020
#define TX4927_DMA_CCR_XFSZ(order)	(((order) << 2) & 0x0000001c)
#define TX4927_DMA_CCR_XFSZ_1W	TX4927_DMA_CCR_XFSZ(2)
#define TX4927_DMA_CCR_XFSZ_2W	TX4927_DMA_CCR_XFSZ(3)
#define TX4927_DMA_CCR_XFSZ_4W	TX4927_DMA_CCR_XFSZ(4)
#define TX4927_DMA_CCR_XFSZ_8W	TX4927_DMA_CCR_XFSZ(5)
#define TX4927_DMA_CCR_XFSZ_16W	TX4927_DMA_CCR_XFSZ(6)
#define TX4927_DMA_CCR_XFSZ_32W	TX4927_DMA_CCR_XFSZ(7)
#define TX4927_DMA_CCR_MEMIO	0x00000002
#define TX4927_DMA_CCR_SNGAD	0x00000001

/* bits for CSRn */
#define TX4927_DMA_CSR_CHNEN	0x00000400
#define TX4927_DMA_CSR_STLXFER	0x00000200
#define TX4927_DMA_CSR_CHNACT	0x00000100
#define TX4927_DMA_CSR_ABCHC	0x00000080
#define TX4927_DMA_CSR_NCHNC	0x00000040
#define TX4927_DMA_CSR_NTRNFC	0x00000020
#define TX4927_DMA_CSR_EXTDN	0x00000010
#define TX4927_DMA_CSR_CFERR	0x00000008
#define TX4927_DMA_CSR_CHERR	0x00000004
#define TX4927_DMA_CSR_DESERR	0x00000002
#define TX4927_DMA_CSR_SORERR	0x00000001

/*
 * IRC
 */
#define TX4927_IR_MAX_LEVEL	7

/* IRCER : Int. Control Enable */
#define TX4927_IRCER_ICE	0x00000001

/* IRCR : Int. Control */
#define TX4927_IRCR_LOW	0x00000000
#define TX4927_IRCR_HIGH	0x00000001
#define TX4927_IRCR_DOWN	0x00000002
#define TX4927_IRCR_UP	0x00000003

/* IRSCR : Int. Status Control */
#define TX4927_IRSCR_EIClrHE	0x01000000
#define TX4927_IRSCR_EIClrH_MASK	0x000f0000
#define TX4927_IRSCR_EIClrLE	0x00000100
#define TX4927_IRSCR_EIClrL_MASK	0x0000000f

/* IRCSR : Int. Current Status */
#define TX4927_IRCSR_IF	0x00010000
#define TX4927_IRCSR_ILV_MASK	0x00000700
#define TX4927_IRCSR_IVL_MASK	0x0000001f

#define TX4927_IR_ECCERR	0
#define TX4927_IR_WTOERR	1
#define TX4927_NUM_IR_INT	6
#define TX4927_IR_INT(n)	(2 + (n))
#define TX4927_NUM_IR_SIO	2
#define TX4927_IR_SIO(n)	(8 + (n))
#define TX4927_NUM_IR_DMA	4
#define TX4927_IR_DMA(n)	(10 + (n))
#define TX4927_IR_PIO	14
#define TX4927_IR_PDMAC	15
#define TX4927_IR_PCIC	16
#define TX4927_NUM_IR_TMR	3
#define TX4927_IR_TMR(n)	(17 + (n))
#define TX4927_IR_PCIERR	22
#define TX4927_IR_PCIPME	23
#define TX4927_IR_ACLC	24
#define TX4927_IR_ACLCPME	25
#define TX4927_NUM_IR	32

/*
 * PCIC
 */
/* bits for PCICMD */
/* see PCI_COMMAND_XXX in linux/pci.h */

/* bits for PCISTAT */
/* see PCI_STATUS_XXX in linux/pci.h */

/* bits for IOBA/MBA */
/* see PCI_BASE_ADDRESS_XXX in linux/pci.h */

/* bits for G2PSTATUS/G2PMASK */
#define TX4927_PCIC_G2PSTATUS_ALL	0x00000003
#define TX4927_PCIC_G2PSTATUS_TTOE	0x00000002
#define TX4927_PCIC_G2PSTATUS_RTOE	0x00000001

/* bits for PCIMASK (see also PCI_STATUS_XXX in linux/pci.h */
#define TX4927_PCIC_PCISTATUS_ALL	0x0000f900

/* bits for PBACFG */
#define TX4927_PCIC_PBACFG_FIXPA	0x00000008
#define TX4927_PCIC_PBACFG_RPBA	0x00000004
#define TX4927_PCIC_PBACFG_PBAEN	0x00000002
#define TX4927_PCIC_PBACFG_BMCEN	0x00000001

/* bits for G2PMnGBASE */
#define TX4927_PCIC_G2PMnGBASE_BSDIS	_CONST64(0x0000002000000000)
#define TX4927_PCIC_G2PMnGBASE_ECHG	_CONST64(0x0000001000000000)

/* bits for G2PIOGBASE */
#define TX4927_PCIC_G2PIOGBASE_BSDIS	_CONST64(0x0000002000000000)
#define TX4927_PCIC_G2PIOGBASE_ECHG	_CONST64(0x0000001000000000)

/* bits for PCICSTATUS/PCICMASK */
#define TX4927_PCIC_PCICSTATUS_ALL	0x000007dc
#define TX4927_PCIC_PCICSTATUS_PMESID	0x00000400
#define TX4927_PCIC_PCICSTATUS_TLBD	0x00000200
#define TX4927_PCIC_PCICSTATUS_NIBD	0x00000100
#define TX4927_PCIC_PCICSTATUS_ZIBD	0x00000080
#define TX4927_PCIC_PCICSTATUS_PERRO	0x00000020
#define TX4927_PCIC_PCICSTATUS_SERRO	0x00000010
#define TX4927_PCIC_PCICSTATUS_GBED	0x00000008
#define TX4927_PCIC_PCICSTATUS_IAA	0x00000004
#define TX4927_PCIC_PCICSTATUS_IWB	0x00000002
#define TX4927_PCIC_PCICSTATUS_E2PDONE	0x00000001

/* bits for PCICCFG */
#define TX4927_PCIC_PCICCFG_LBWC_MASK	0x0fff0000
#define TX4927_PCIC_PCICCFG_HRST	0x00000800
#define TX4927_PCIC_PCICCFG_SRST	0x00000400
#define TX4927_PCIC_PCICCFG_IRBER	0x00000200
#define TX4927_PCIC_PCICCFG_IMSE(ch)	(0x00000100>>(ch))
#define TX4927_PCIC_PCICCFG_IMSE0	0x00000100
#define TX4927_PCIC_PCICCFG_IMSE1	0x00000080
#define TX4927_PCIC_PCICCFG_IMSE2	0x00000040
#define TX4927_PCIC_PCICCFG_IISE	0x00000020
#define TX4927_PCIC_PCICCFG_ATR	0x00000010
#define TX4927_PCIC_PCICCFG_ICAE	0x00000008

/* bits for P2GMnGBASE */
#define TX4927_PCIC_P2GMnGBASE_TMEMEN	_CONST64(0x0000004000000000)
#define TX4927_PCIC_P2GMnGBASE_TBSDIS	_CONST64(0x0000002000000000)
#define TX4927_PCIC_P2GMnGBASE_TECHG	_CONST64(0x0000001000000000)

/* bits for P2GIOGBASE */
#define TX4927_PCIC_P2GIOGBASE_TIOEN	_CONST64(0x0000004000000000)
#define TX4927_PCIC_P2GIOGBASE_TBSDIS	_CONST64(0x0000002000000000)
#define TX4927_PCIC_P2GIOGBASE_TECHG	_CONST64(0x0000001000000000)

#define TX4927_PCIC_IDSEL_AD_TO_SLOT(ad)	((ad) - 11)
#define TX4927_PCIC_MAX_DEVNU	TX4927_PCIC_IDSEL_AD_TO_SLOT(32)

/*
 * CCFG
 */
/* CCFG : Chip Configuration */
#define TX4927_CCFG_WDRST	_CONST64(0x0000020000000000)
#define TX4927_CCFG_WDREXEN	_CONST64(0x0000010000000000)
#define TX4927_CCFG_BCFG_MASK	_CONST64(0x000000ff00000000)
#define TX4927_CCFG_TINTDIS	0x01000000
#define TX4927_CCFG_PCI66	0x00800000
#define TX4927_CCFG_PCIMIDE	0x00400000
#define TX4927_CCFG_DIVMODE2_MASK	0x00080000
#define TX4927_CCFG_DIVMODE2_4	0x00000000
#define TX4927_CCFG_DIVMODE2_1	0x00080000
#define TX4927_CCFG_DIVMODE_MASK	0x00060000
#define TX4927_CCFG_DIVMODE_2	0x00000000
#define TX4927_CCFG_DIVMODE_3	0x00020000
#define TX4927_CCFG_DIVMODE_4	0x00040000
#define TX4927_CCFG_DIVMODE_2_5	0x00060000
#define TX4927_CCFG_BEOW	0x00010000
#define TX4927_CCFG_WR	0x00008000
#define TX4927_CCFG_TOE	0x00004000
#define TX4927_CCFG_PCIXARB	0x00002000
#define TX4927_CCFG_PCIDIVMODE_MASK	0x00001800
#define TX4927_CCFG_PCIDIVMODE_2_5	0x00000000
#define TX4927_CCFG_PCIDIVMODE_3	0x00000800
#define TX4927_CCFG_PCIDIVMODE_5	0x00001000
#define TX4927_CCFG_PCIDIVMODE_6	0x00001800
#define TX4927_CCFG_SYSSP_MASK	0x000000c0
#define TX4927_CCFG_ENDIAN	0x00000004
#define TX4927_CCFG_HALT	0x00000002
#define TX4927_CCFG_ACEHOLD	0x00000001

/* PCFG : Pin Configuration */
#define TX4927_PCFG_SDCLKDLY_MASK	0x30000000
#define TX4927_PCFG_SDCLKDLY(d)	((d)<<28)
#define TX4927_PCFG_SYSCLKEN	0x08000000
#define TX4927_PCFG_SDCLKEN_ALL	0x07800000
#define TX4927_PCFG_SDCLKEN(ch)	(0x00800000<<(ch))
#define TX4927_PCFG_PCICLKEN_ALL	0x003f0000
#define TX4927_PCFG_PCICLKEN(ch)	(0x00010000<<(ch))
#define TX4927_PCFG_SEL2	0x00000200
#define TX4927_PCFG_SEL1	0x00000100
#define TX4927_PCFG_DMASEL_ALL	0x000000ff
#define TX4927_PCFG_DMASEL0_MASK	0x00000003
#define TX4927_PCFG_DMASEL1_MASK	0x0000000c
#define TX4927_PCFG_DMASEL2_MASK	0x00000030
#define TX4927_PCFG_DMASEL3_MASK	0x000000c0
#define TX4927_PCFG_DMASEL0_DRQ0	0x00000000
#define TX4927_PCFG_DMASEL0_SIO1	0x00000001
#define TX4927_PCFG_DMASEL0_ACL0	0x00000002
#define TX4927_PCFG_DMASEL0_ACL2	0x00000003
#define TX4927_PCFG_DMASEL1_DRQ1	0x00000000
#define TX4927_PCFG_DMASEL1_SIO1	0x00000004
#define TX4927_PCFG_DMASEL1_ACL1	0x00000008
#define TX4927_PCFG_DMASEL1_ACL3	0x0000000c
#define TX4927_PCFG_DMASEL2_DRQ2	0x00000000	/* SEL2=0 */
#define TX4927_PCFG_DMASEL2_SIO0	0x00000010	/* SEL2=0 */
#define TX4927_PCFG_DMASEL2_ACL1	0x00000000	/* SEL2=1 */
#define TX4927_PCFG_DMASEL2_ACL2	0x00000020	/* SEL2=1 */
#define TX4927_PCFG_DMASEL2_ACL0	0x00000030	/* SEL2=1 */
#define TX4927_PCFG_DMASEL3_DRQ3	0x00000000
#define TX4927_PCFG_DMASEL3_SIO0	0x00000040
#define TX4927_PCFG_DMASEL3_ACL3	0x00000080
#define TX4927_PCFG_DMASEL3_ACL1	0x000000c0

/* CLKCTR : Clock Control */
#define TX4927_CLKCTR_ACLCKD	0x02000000
#define TX4927_CLKCTR_PIOCKD	0x01000000
#define TX4927_CLKCTR_DMACKD	0x00800000
#define TX4927_CLKCTR_PCICKD	0x00400000
#define TX4927_CLKCTR_TM0CKD	0x00100000
#define TX4927_CLKCTR_TM1CKD	0x00080000
#define TX4927_CLKCTR_TM2CKD	0x00040000
#define TX4927_CLKCTR_SIO0CKD	0x00020000
#define TX4927_CLKCTR_SIO1CKD	0x00010000
#define TX4927_CLKCTR_ACLRST	0x00000200
#define TX4927_CLKCTR_PIORST	0x00000100
#define TX4927_CLKCTR_DMARST	0x00000080
#define TX4927_CLKCTR_PCIRST	0x00000040
#define TX4927_CLKCTR_TM0RST	0x00000010
#define TX4927_CLKCTR_TM1RST	0x00000008
#define TX4927_CLKCTR_TM2RST	0x00000004
#define TX4927_CLKCTR_SIO0RST	0x00000002
#define TX4927_CLKCTR_SIO1RST	0x00000001


#ifndef _LANGUAGE_ASSEMBLY

#define tx4927_sdramcptr	((struct tx4927_sdramc_reg *)TX4927_SDRAMC_REG)
#define tx4927_ebuscptr		((struct tx4927_ebusc_reg *)TX4927_EBUSC_REG)
#define tx4927_dmaptr		((struct tx4927_dma_reg *)TX4927_DMA_REG)
#define tx4927_ircptr		((struct tx4927_irc_reg *)TX4927_IRC_REG)
#define tx4927_pcicptr		((struct tx4927_pcic_reg *)TX4927_PCIC_REG)
#define tx4927_ccfgptr		((struct tx4927_ccfg_reg *)TX4927_CCFG_REG)
#define tx4927_tmrptr(ch)	((struct txx927_tmr_reg *)TX4927_TMR_REG(ch))
#define tx4927_sioptr(ch)	((struct txx927_sio_reg *)TX4927_SIO_REG(ch))
#define tx4927_pioptr		((struct txx927_pio_reg *)TX4927_PIO_REG)
#define tx4927_aclcptr		((struct tx4927_aclc_reg *)TX4927_ACLC_REG)

#define TX4927_REV_MAJ_MIN()	((unsigned long)tx4927_ccfgptr->crir & 0x00ff)
#define TX4927_REV_PCODE()	((unsigned long)tx4927_ccfgptr->crir >> 16)

#endif /* _LANGUAGE_ASSEMBLY */

#endif /* __ASM_MIPS_TX4927_H */
