/* Assertion facility for the kernel.

   todo: Provide some way of releasing resources when an assertion
   fails.

   --- Taken from /usr/include/assert.h.  Some things (such as ANSI /
   SysV conformance) have been removed.  <sys/cdefs.h> macros have
   been inlined. --- */

/* Copyright (C) 1991, 1992, 1994, 1995 Free Software Foundation, Inc.
This file (assert.h) is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the, 1992 Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#ifdef	_ASSERT_H
# undef	_ASSERT_H
# undef	assert
#else
/* This prints an "Assertion failed" message and aborts.  */
static void __assert_fail (__const char *__assertion,
			   __const char *__file,
			   unsigned int __line,
			   __const char *__function)
     __attribute__ ((/*__noreturn__, */__unused__));

static void
__assert_fail(char const *assertion,
	      char const *file,
	      unsigned line,
	      char const *function) 
{
	printk(KERN_CRIT "%s:%u: %s: Assertion `%s' failed.\n",
	       file, line, function, assertion);
	/* pjm: I don't want this in released code:
           *(volatile int *)0 = 0; */
}
#endif /* !ASSERT_H */

#define	_ASSERT_H	1

#ifdef	NDEBUG
# define assert(expr)		((void) 0)
#else /* Not NDEBUG.  */

# define assert(expr)							      \
  ((void) ((expr) ||							      \
	   (__assert_fail (#expr,					      \
			   __FILE__, __LINE__, __ASSERT_FUNCTION), 0)))


/* Version 2.4 and later of GCC define a magical variable `__PRETTY_FUNCTION__'
   which contains the name of the function currently being defined.
   This is broken in G++ before version 2.6.  */
# if (!defined (__GNUC__) || __GNUC__ < 2 || \
     __GNUC_MINOR__ < (defined (__cplusplus) ? 6 : 4))
#  define __ASSERT_FUNCTION	((__const char *) 0)
# else
#  define __ASSERT_FUNCTION	__PRETTY_FUNCTION__
# endif
#endif /* NDEBUG.  */
