#ifndef __URLFILTER_H__
#define __URLFILTER_H__

#ifdef __KERNEL__
#include <asm/mconfig.h>
#include <linux/skbuff.h>
#include <linux/list.h>
#endif

#define URLLOG_MAX	1024
#define URLLOG_HASH_SIZE 199
#define URL_TARGET_SIZE	128

#ifdef __KERNEL__
// the following structure is used for kernel manipulation
typedef struct {
        struct list_head        list;
        struct list_head        hash_list;
        unsigned long           time;
        unsigned long           srcip;
	char			target[URL_TARGET_SIZE];
} URLLOG;

extern void submit_url_records(REG_URL_ACCESS_CONF *);
extern int process_url_access(struct sk_buff *skb);
#endif

// the structure provides application view
typedef struct {
        unsigned long           time;
        unsigned long           srcip;
	char			target[URL_TARGET_SIZE];
} URLLOG_INFO;
 
#endif	// __URLFILTER_H__

