#ifndef __TX4926DES_H__
#define __TX4926DES_H__

/* Define Data Types */
#define MIPS32	1

/* Data Types */
#ifdef MIPS64
typedef int 		INT64;
typedef short		INT32;
typedef unsigned int 	UINT64;
typedef	unsigned short	UINT32;
#elif MIPS32
typedef long long		INT64;
typedef int			INT32;
typedef unsigned long long 	UINT64;
typedef unsigned int	 	UINT32;
#endif

#define DES_64(addr) 	((volatile UINT64 *)addr)
#define DES_32(addr) 	((volatile UINT32 *)addr)

#define MEMBASE		0xA0000000
#define Phy2Virt(addr)	addr + MEMBASE
#define Virt2Phy(addr)	addr - MEMBASE	


/* TX4926 DESC Module Registers */
#define MREG		0xFF1FA000	/* Message Register */
#define CREG		0xFF1FA010	/* Cipher Register */
#define DREG		0xFF1FA020	/* Data Register (InitialVector-IV) */
#define K1REG		0xFF1FA040	/* Key 1 Register */
#define K2REG		0xFF1FA050	/* Key 2 Register */
#define K3REG		0xFF1FA060	/* Key 3 Register */
#define CTRLREG		0xFF1FA0E0	/* Control Register */
#define PRREG		0xFF1FA0F0	/* Program Register */
#define SREG		0xFF1FA0F4	/* Status Register */
#define DCAREG		0xFF1FA100	/* DDMAC Chain Address Register */
#define DSAREG		0xFF1FA104	/* DDMAC Source Address Register */
#define DDAREG		0xFF1FA108	/* DDMAC Destination Address Register */
#define DCNTREG		0xFF1FA10C	/* DDMAC Count Register */
#define DCTRLREG	0xFF1FA110	/* DDMAC Control Register */
#define DSTATREG	0xFF1FA114	/* DDMAC Status Register */
#define DDBREG0		0xFF1FA120	/* DDMAC Data Buffer Register 0 */
#define DDBREG1		0xFF1FA124	/* DDMAC Data Buffer Register 1 */
#define DDBREG2		0xFF1FA128	/* DDMAC Data Buffer Register 2 */
#define DDBREG3		0xFF1FA12C	/* DDMAC Data Buffer Register 3 */
#define DDBREG4		0xFF1FA130	/* DDMAC Data Buffer Register 4 */
#define DDBREG5		0xFF1FA134	/* DDMAC Data Buffer Register 5 */
#define DDBREG6		0xFF1FA138	/* DDMAC Data Buffer Register 6 */
#define DDBREG7		0xFF1FA13C	/* DDMAC Data Buffer Register 7 */


/* TX4926 CTRLREG Register Contents */
#define CTRLREG_MWST	0x00000001	/* MREG Write Start, set this bit when using DDMAC */
#define CTRLREG_CRCLR	0x00000002	/* CREG Read Clear, set this bit when using DDMAC */
#define CTRLREG_DDMAE	0x00000004	/* DDMAC Enable */
#define CTRLREG_DINTE	0x00000008	/* DESC Interrupt Enable */


/* TX4926 PRREG Register Contents */
#define PRREG_DMS	0x00000001	/* Decode Mode Select */
#define PRREG_CMS	0x00000002	/* CBC Mode Select */
#define PRREG_TDMS 	0x00000004	/* Triple DES Mode Select */


/* TX4926 SREG Register Contents */
#define SREG_BUSY	0x00000001	/* DESC Busy */
#define SREG_ICR	0x00000002	/* Interrupt Clear Request */
#define SREG_MRDY	0x00000004	/* MREG Ready */


/* TX4926 DCTRLREG Register Contents */
#define DCTRLREG_DRST	0x00000001	/* DDMAC Reset */
#define DCTRLREG_XACT	0x00000040	/* Xfer Action */
#define DCTRLREG_CEN	0x00000080	/* Chain Enable */
#define DCTRLREG_DIETD	0x00000100	/* DDMAC Interrupt Enable on Transfer Done */
#define DCTRLREG_DIECD	0x00000200	/* DDMAC Interrupt Enable on Chian Done */
#define DCTRLREG_DIEE	0x00000400	/* DDMAC Interrupt Enable on Error */
#define DCTRLREG_RFIFO	0x00200000	/* DDMAC Reset FIFO */


/* TX4926 DSTATREG Register Contents */
#define DSTATREG_CBERR	0x00000001	/* Chain Bus Error */
#define DSTATREG_SBERR	0x00000002	/* Source Bus Error */
#define DSTATREG_DBERR	0x00000004	/* Destination Bus Error */
#define DSTATREG_CERR	0x00000008	/* Configuration Error */
#define DSTATREG_NTC	0x00000040 	/* Normal Transfer Complete */
#define DSTATREG_NCC	0x00000080	/* Normal Chain Complete */
#define DSTATREG_ACC	0x00000100	/* Abnormal Chain Complete */
#define DSTATREG_XACTS	0x00000200	/* Xfer Active Status */
#define DSTATREG_CENS	0x00000400	/* Chain Enable Status */
#define DSTATREG_DDIS	0x00000800	/* DDMAC Done Interrupt Status */
#define DSTATREG_DEIS 	0x00001000	/* DDMAC Error Interrupt Status */
#define DSTATREG_FRP	0x00070000	/* FIFO Read Pointer */
#define DSTATREG_FWP	0x00380000	/* FIFO Write Pointer */
#define DSTATREG_SFVEC	0x0F000000	/* Source FIFO Valid Entry Count */
#define DSTATREG_DFVEC	0xF0000000	/* Destination FIFO Valid Entry Count */


/* Define DESC Operation Mode */
#define Encode_CBC_Single	PRREG_CMS				/* (Encode, CBC mode, Single DES) */
#define Decode_CBC_Single	PRREG_DMS | PRREG_CMS			/* (Decode, CBC mode, Single DES) */
#define Encode_ECB_Single	0					/* (Encode, ECB mode, Single DES) */
#define Decode_ECB_Single	PRREG_DMS				/* (Decode, ECB mode, Single DES) */
#define Encode_CBC_Triple	PRREG_CMS | PRREG_TDMS			/* (Encode, CBC mode, Triple DES) */
#define Decode_CBC_Triple	PRREG_DMS | PRREG_CMS | PRREG_TDMS	/* (Decode, CBC mode, Triple DES) */
#define Encode_ECB_Triple 	PRREG_TDMS				/* (Encode, ECB mode, Triple DES) */
#define Decode_ECB_Triple	PRREG_DMS | PRREG_TDMS 			/* (Decode, ECB mode, Triple DES) */


#endif	// __TX4926DES_H__
